/*
** FAAD2 - Freeware Advanced Audio (AAC) Decoder including SBR decoding
** Copyright (C) 2003-2004 M. Bakker, Ahead Software AG, http://www.nero.com
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** Any non-GPL usage of this software or parts of this software is strictly
** forbidden.
**
** Commercial non-GPL licensing of this software is possible.
** For more info contact Ahead Software through Mpeg4AAClicense@nero.com.
**
** $Id: mp4util.c,v 1.21 2011/05/03 00:00:00 PDSoft Exp $
**/

#include <stdlib.h>
#include <stdio.h>
#include "mp4ff.h"
#include "newfunc\newfunc.h"

int32_t mp4ff_read_data(mp4ff_t *f, int8_t *data, uint32_t size)
{
 int32_t result = f->stream->read(f->stream->user_data, data, size);

 if(result>0)
  f->current_position += result;

 return result;
}

int32_t mp4ff_set_position(mp4ff_t *f,mpxp_filesize_t position)
{
 mpxp_filesize_t ret=f->stream->seek(f->stream->user_data, (mpxp_filesize_t)position, SEEK_SET);

 if(ret<0)
  return ret;

 if(ret!=(mpxp_filesize_t)position)
  return -1;

 f->current_position = position;

 return 0;
}

mpxp_filesize_t mp4ff_position(const mp4ff_t *f)
{
 return f->current_position;
}

uint64_t mp4ff_read_int64(mp4ff_t *f)
{
 int8_t data[8];
 if(mp4ff_read_data(f, data, 8)!=8)
  return 0;
 return PDS_GETB_BEU64(&data[0]);
}

uint32_t mp4ff_read_int32(mp4ff_t *f)
{
 int8_t data[4];
 if(mp4ff_read_data(f, data, 4)!=4)
  return 0;
 return PDS_GETB_BE32(data);
}

uint32_t mp4ff_read_int24(mp4ff_t *f)
{
 int8_t data[4];
 if(mp4ff_read_data(f, data, 3)!=3)
  return 0;
 return PDS_GETB_BE24(data);
}

uint32_t mp4ff_read_int16(mp4ff_t *f)
{
 int8_t data[4];
 if(mp4ff_read_data(f, data, 2)!=2)
  return 0;
 return PDS_GETB_BE16(data);
}

uint8_t mp4ff_read_char(mp4ff_t *f)
{
 uint8_t output=0;
 mp4ff_read_data(f, (int8_t *)(&output), 1);
 return output;
}

char *mp4ff_read_string(mp4ff_t * f,uint32_t length)
{
 char *str = (char*)malloc(length + 1);
 if(str!=0){
  if((uint32_t)mp4ff_read_data(f,(int8_t *)str,length)!=length){
   free(str);
   str = 0;
  }else{
   str[length] = 0;
  }
 }
 return str;
}

uint32_t mp4ff_read_mp4_descr_length(mp4ff_t *f)
{
 uint8_t b,numBytes = 0;
 uint32_t length = 0;

 do{
  b = mp4ff_read_char(f);
  numBytes++;
  length = (length << 7) | (b & 0x7F);
 }while ((b & 0x80) && (numBytes<4));

 return length;
}
