//**************************************************************************
//*                     This file is part of the                           *
//*             AudioCV - a general audio converter program                *
//*                  The source code of AudioCV is                         *
//*          (c) copyright 2001-2004 by PDSoft (Attila Padar)              *
//*                    http://mpxplay.cjb.net                              *
//* email: mpxplay@freemail.hu (please write AudioCV in the subject field) *
//**************************************************************************

#ifndef audiocv_h
#define audiocv_h

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <ctype.h>
#include <malloc.h>
#include <io.h>
#include <time.h>

#define PRG_VERSION "1.22"
#ifdef _WIN32
 #define OS_TYPE "Win32"
#else
 #ifdef _DOS
  #define OS_TYPE "DOS"
 #else
  #define OS_TYPE "Unknown OS"
 #endif
#endif

#define MAXFREEOPTS    10 // non-options
#define DISP_REF_INT   22 // min. display refresh interval (in hsecs)
#define KEY_ESC      0x1b

// PMCI and PCMF must be 4 bytes (same size)
typedef long  PCM_CV_TYPE_I;// max. 32 bit input/output pcm format (integer)
typedef unsigned long PCM_CV_TYPE_UI;
typedef float PCM_CV_TYPE_F;// (float for ogg,mp3)

#define PCM_INSAMPLES  1152
#define PCM_BUFFSIZE   (PCM_INSAMPLES+16)
#define PCM_MAX_BITS   (sizeof(PCM_CV_TYPE_I)*8)

//bittypes
#define BITTYPE_UNDEFINED 0  // usually at float input  (range -1...+1)
#define BITTYPE_UNSCALED  1  // usually at float output (range -1...+1)
//                       >1  // scaled data to n bits (float or int too)
#define BITTYPE_DEFAULT  16

//filetypes
#define FT_UNKNOWN  0
#define FT_WAV      1
#define FT_OGG      2
#define FT_MP3      3  // not implemented

//filemodes
#define CF_FLOAT    1  // floating point input or output (like ogg,mp3) (else integer like wav)
#define CF_OUTPUT   2  // create output

//conversion functions
#define CF_CUTZERO    4   // cut zero samples (below cv_cutlimit)
#define CF_MUTEZERO   8   // mute sound (below cv_mutelimit)
#define CF_ANALYZE    16  // analyze sound, get max. cv_normdb (use cv_cliplimit,cv_signlimit)
#define CF_SWAPCHAN   32  // swap audio channels (reverse stereo)

#define CF_CHANNELS   128  // convert channel number n to m
#define CF_NORMALIZE  256  // modify amplitude (with analized value or with a manual one)
#define CF_FREQ       512  // modify sampling frequency

#define CF_FCONV  (CF_FLOAT|CF_CHANNELS|CF_NORMALIZE|CF_FREQ)  // floating point conversion needed (PCMI_to_PCMF)
#define CF_ICONV  (CF_CUTZERO|CF_MUTEZERO|CF_ANALYZE)  // integer conversion needed (PCMF_to_PCMI)

#define CF_PASS1  (CF_CUTZERO|CF_MUTEZERO|CF_ANALYZE)
#define CF_PASS2  (CF_OUTPUT|CF_CUTZERO|CF_MUTEZERO|CF_SWAPCHAN|CF_CHANNELS|CF_NORMALIZE|CF_FREQ)

//other functions
#define FUNC_RENAMEFILES  1 // input and output filename are the same
#define FUNC_DELETEINFILE 2 // delete input
#define FUNC_OVERWRITE    4 // overwrite existent files

typedef struct acv_fileinfo{
 unsigned int filetype;   // type of file (wav,ogg)
 unsigned int filemode;   // int or float + conversion functions
 unsigned int channels;   // number of audio channels
 unsigned int freq;       // frequency
 unsigned int databits;   // used only in wav header
 unsigned int scalebits;// used in acv_conv
 unsigned int bitrate;    // ogg,mp3
 unsigned int bytespersample; // for integer conversions
 unsigned long currsamplenum;
 unsigned long allsamplenum;
 unsigned long blocksamplenum;
 long headerlen;
 char *buffer;
 char *filename;
 char *tag_artist,*tag_title,*tag_album,*tag_date,*tag_genre,*tag_comment;
 void *decoder_info;        // OGG
 FILE *fp;
}acv_fileinfo;

#define acv_fromdB(x)  (exp((x)*0.115129254649702278f))
#define acv_todB(x)    (((x)==0.)? 0.:log(fabs(x))*8.68588963806503678f)

#if defined(__WATCOMC__)
 void pds_ftoi(PCM_CV_TYPE_F *,PCM_CV_TYPE_I *);
 #pragma aux pds_ftoi parm [edi][esi] = "fld dword ptr [edi]" "fistp dword ptr [esi]"
#else
 #if defined(_MSC_VER)
  static __inline PCM_CV_TYPE_I pds_ftoi(PCM_CV_TYPE_F f)
  {
   PCM_CV_TYPE_I i;
   __asm{
    fld f
    fistp i
   }
   return i;
  }
 #endif
#endif

#define ACV_ERROR_FILE_CANTOPEN      -1
#define ACV_ERROR_FILE_ALREADYEXISTS -32
#define ACV_ERROR_FILE_CANTWRITE     -2
#define ACV_ERROR_FILETYPE_UNKNOWN   -4
#define ACV_ERROR_MEMORY        -8
#define ACV_ERROR_USERABORT     -16

#endif
