//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2006 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: software tone (bass and treble only) and loudness
//          with SuperEq lib from http://shibatch.sourceforge.net

#include "au_mixer\au_mixer.h"
#include "au_mixer\mix_func.h"
#include "newfunc\newfunc.h"
#include "libsupeq\supereq.h"

#define TONE_EQ_BANDS  11
#define EQdB  12

static void *equ_datas;
static long last_srate,last_nch,delay_count;
//static long eq_freqs[TONE_EQ_BANDS]={44,87,173,345,690,1379,2757,5513,11839,16744}; // 10 bands
static long eq_freqs[TONE_EQ_BANDS]={44,87,173,345,690,1379,2757,5513,8372,11839,16744}; // 11 bands
static float lbands[TONE_EQ_BANDS],rbands[TONE_EQ_BANDS];

static one_mixerfunc_info MIXER_FUNCINFO_tone_bass;
static one_mixerfunc_info MIXER_FUNCINFO_tone_treble;

static void calculate_eqgain(struct mpxplay_audioout_info_s *aui)
{
 int i,bass,data[TONE_EQ_BANDS];

 bass=aui->card_mixer_values[AU_MIXCHAN_BASS];
 data[0]=bass;
 data[1]=bass;
 //data[1]=(bass-50)/2+50;

 for(i=2;i<TONE_EQ_BANDS;i++)
  data[i]=50;

 data[TONE_EQ_BANDS-3]=(aui->card_mixer_values[AU_MIXCHAN_TREBLE]-50)/4+50;
 data[TONE_EQ_BANDS-2]=(aui->card_mixer_values[AU_MIXCHAN_TREBLE]-50)/2+50;
 data[TONE_EQ_BANDS-1]=aui->card_mixer_values[AU_MIXCHAN_TREBLE];

 for(i=0;i<TONE_EQ_BANDS;i++)
  if(data[i]>50)
   lbands[i] = rbands[i] = pow(10,(float)(data[i]-50)/50.0*EQdB/20.0); // logarithmic
  else
   lbands[i] = rbands[i] = (float)((data[i]))/50.f; // linear to zero

 equ_makeTable(equ_datas,lbands,rbands,aui->freq_song);
}

static int mixer_tone_init(struct mpxplay_audioout_info_s *aui,int inittype)
{
 funcbit_disable(aui->card_infobits,AUINFOS_CARDINFOBIT_HWTONE);
 switch(inittype){
  case MIXER_INITTYPE_INIT:
        if(!equ_datas)
         equ_datas=equ_init(14,TONE_EQ_BANDS,eq_freqs);
        if(!equ_datas)
         return 0;
        break;
  case MIXER_INITTYPE_REINIT:
        if(last_srate==aui->freq_song && last_nch==aui->chan_card)
         break;
  case MIXER_INITTYPE_START:
        last_srate=aui->freq_song;
        last_nch=aui->chan_card;
        calculate_eqgain(aui);
        delay_count=8192;
  case MIXER_INITTYPE_LQHQSW:
  case MIXER_INITTYPE_RESET:
        equ_clearbuf(equ_datas,MIXER_SCALE_BITS,aui->freq_song);
        break;
  case MIXER_INITTYPE_CLOSE:
        equ_quit(equ_datas);
        break;
 }
 return 1;
}

static void mixer_tone_lq(struct mpxplay_audioout_info_s *aui)
{
 unsigned int sn=aui->samplenum/aui->chan_card;
 cv_n_bits_to_float((PCM_CV_TYPE_S *)aui->pcm_sample,aui->samplenum,aui->bytespersample_mixer,1);
 equ_modifysamples_float(equ_datas,(float *)aui->pcm_sample,sn,aui->chan_card);
 cv_float_to_n_bits((PCM_CV_TYPE_S *)aui->pcm_sample,aui->samplenum,1,MIXER_SCALE_BITS/8,0);
 if(delay_count>=sn){ // !!! hack
  aui->samplenum=0;
  delay_count-=sn;
 }
}

static void mixer_tone_hq(struct mpxplay_audioout_info_s *aui)
{
 unsigned int sn=aui->samplenum/aui->chan_card;
 equ_modifysamples_float(equ_datas,(float *)aui->pcm_sample,sn,aui->chan_card);
 if(delay_count>=sn){ // !!! hack
  aui->samplenum=0;
  delay_count-=sn;
 }
}

static int mixer_tone_checkvar_bass(struct mpxplay_audioout_info_s *aui)
{
 if((aui->card_mixer_values[AU_MIXCHAN_BASS]!=MIXER_FUNCINFO_tone_bass.var_center)
   || (aui->card_mixer_values[AU_MIXCHAN_TREBLE]!=MIXER_FUNCINFO_tone_treble.var_center)){
  return 1;
 }
 return 0;
}

static int mixer_tone_checkvar_treble(struct mpxplay_audioout_info_s *aui)
{
 if(aui->card_mixer_values[AU_MIXCHAN_TREBLE]!=MIXER_FUNCINFO_tone_treble.var_center)
  return 1;
 return 0;
}

static int tone_setvar(one_mixerfunc_info *infop,int currvalue,unsigned int setmode,int modvalue)
{
 int newvalue;

 if(!equ_datas)
  return currvalue;

 switch(setmode){
  case MIXER_SETMODE_RELATIVE:newvalue=currvalue+modvalue*infop->var_step;
                              if((currvalue<infop->var_center && newvalue>infop->var_center) || (currvalue>infop->var_center && newvalue<infop->var_center))
                               newvalue=infop->var_center;
                              break;
  case MIXER_SETMODE_ABSOLUTE:newvalue=modvalue;break;
  case MIXER_SETMODE_RESET   :newvalue=infop->var_center;break;
 }
 if(newvalue<infop->var_min)
  newvalue=infop->var_min;
 else
  if(newvalue>infop->var_max)
   newvalue=infop->var_max;

 return newvalue;
}

static void mixer_tone_setvar_bass(struct mpxplay_audioout_info_s *aui,unsigned int setmode,int value)
{
 aui->card_mixer_values[AU_MIXCHAN_BASS]=tone_setvar(&MIXER_FUNCINFO_tone_bass,aui->card_mixer_values[AU_MIXCHAN_BASS],setmode,value);
 calculate_eqgain(aui);
}

static void mixer_tone_setvar_treble(struct mpxplay_audioout_info_s *aui,unsigned int setmode,int value)
{
 aui->card_mixer_values[AU_MIXCHAN_TREBLE]=tone_setvar(&MIXER_FUNCINFO_tone_treble,aui->card_mixer_values[AU_MIXCHAN_TREBLE],setmode,value);
 calculate_eqgain(aui);
}

static one_mixerfunc_info MIXER_FUNCINFO_tone_bass={
 "MIX_TONE_BASS",
 "mxtb",
 NULL,
 MIXER_INFOBIT_PARALLEL_DEPENDENCY|MIXER_INFOBIT_EXTERNAL_DEPENDENCY, // loudness|newfile
 0,100,50,3,
 &mixer_tone_init,
 &mixer_tone_lq,
 &mixer_tone_hq,
 &mixer_tone_checkvar_bass,
 &mixer_tone_setvar_bass
};

static one_mixerfunc_info MIXER_FUNCINFO_tone_treble={
 "MIX_TONE_TREBLE",
 "mxtt",
 NULL,
 MIXER_INFOBIT_PARALLEL_DEPENDENCY|MIXER_INFOBIT_EXTERNAL_DEPENDENCY, // loudness|newfile
 0,100,50,3,
 NULL,
 NULL,
 NULL,
 &mixer_tone_checkvar_treble,
 &mixer_tone_setvar_treble
};

//-------------------------------------------------------------------
#define MIXER_TONE_LOUDNESS_DEFAULT_BASS   75
#define MIXER_TONE_LOUDNESS_DEFAULT_TREBLE 80

static int loudness_save_bass=-1,loudness_save_treble=-1;

static void mixer_tone_setvar_loudness(struct mpxplay_audioout_info_s *aui,unsigned int setmode,int value)
{
 if(!equ_datas)
  return;

 switch(setmode){
  case MIXER_SETMODE_RELATIVE:
   if((aui->card_mixer_values[AU_MIXCHAN_BASS]==MIXER_FUNCINFO_tone_bass.var_center) && (aui->card_mixer_values[AU_MIXCHAN_TREBLE]==MIXER_FUNCINFO_tone_treble.var_center)){
    if(loudness_save_bass<0)
     loudness_save_bass=MIXER_TONE_LOUDNESS_DEFAULT_BASS;
    aui->card_mixer_values[AU_MIXCHAN_BASS]=loudness_save_bass;
    if(loudness_save_treble<0)
     loudness_save_treble=MIXER_TONE_LOUDNESS_DEFAULT_TREBLE;
    aui->card_mixer_values[AU_MIXCHAN_TREBLE]=loudness_save_treble;
   }else{
    loudness_save_bass=aui->card_mixer_values[AU_MIXCHAN_BASS];
    aui->card_mixer_values[AU_MIXCHAN_BASS]=MIXER_FUNCINFO_tone_bass.var_center;
    loudness_save_treble=aui->card_mixer_values[AU_MIXCHAN_TREBLE];
    aui->card_mixer_values[AU_MIXCHAN_TREBLE]=MIXER_FUNCINFO_tone_treble.var_center;
   }
   calculate_eqgain(aui);
 }
}

static one_mixerfunc_info MIXER_FUNCINFO_tone_loudness={
 "MIX_TONE_LOUDNESS",
 "mxtl",
 NULL,
 MIXER_INFOBIT_SWITCH,
 0,1,0,0,
 NULL,
 NULL,
 NULL,
 NULL,
 &mixer_tone_setvar_loudness
};

//----------------------------------------------------------------------
int matherr(struct _exception *a)
{
 a->retval=1.0;
 return 1;
}
//----------------------------------------------------------------------

static mpxplay_module_entry_s module_entry_treble={
 MPXPLAY_DLLMODULETYPE_AUMIXER,
 0,
 "MxToneHigh",
 MPXPLAY_DLLMODULEVER_AUMIXER,
 (void *)&MIXER_FUNCINFO_tone_treble
};

static mpxplay_module_entry_s module_entry_bass={
 MPXPLAY_DLLMODULETYPE_AUMIXER,
 0,
 "MxToneBass",
 MPXPLAY_DLLMODULEVER_AUMIXER,
 (void *)&MIXER_FUNCINFO_tone_bass
};

static mpxplay_module_entry_s module_entry_loudness={
 MPXPLAY_DLLMODULETYPE_AUMIXER,
 0,
 "MxToneLoud",
 MPXPLAY_DLLMODULEVER_AUMIXER,
 (void *)&MIXER_FUNCINFO_tone_loudness
};

static mpxplay_dll_entry_s mpxplay_dll_entry_structure={
 MPXPLAY_DLLENTRY_STRUCTURE_VERSION,
 {
  &module_entry_treble,
  &module_entry_bass,
  &module_entry_loudness,
  NULL
 }
};

#ifdef __DOS__
extern void dllstrtr_update_crwdata(unsigned long *cwd);

long __export mpxplay_dll_entrypoint(struct mpxplay_resource_s *p_mrs,unsigned long *crwdata_begin)
{
 dllstrtr_update_crwdata(crwdata_begin);
 return (long)(&mpxplay_dll_entry_structure);
}

#else

__declspec( dllexport ) mpxplay_dll_entry_s *mpxplay_dll_entrypoint(void)
{
 return (&mpxplay_dll_entry_structure);
}

#endif
