       PAGE    ,160                    ; M
; #############################################################################
;
;    NECPINW V2.04 DOS .CPI Code Page file for NEC Pinwriter series printers
;
;    Copyright (C) 1996-2000 by Matthias Paul  
;                               Ubierstrae 28
;                               D-50321 Brhl
;                               GERMANY
;
;    All rights reserved (except those detailed below).
;
;    Registered trademarks and tradenames mentioned inhere are owned
;    by their respective owners.
;
;    EMail: <Matthias.Paul@post.rwth-aachen.de>
;    Web:   http://www.rhrz.uni-bonn.de/~uzs180/mpdokeng.html
;           http://www.freedos.org/
;                ibiblio  /pub/micro/pc-stuff/freedos/files/util/print/cpi/
;
;    Other distribution points (not currently up to date):
;
;    ftp://ftp.rhrz.uni-bonn.de/pub/pc/dos/misc/necpinw.zip
;                                           .../country.zip
;                                           .../mpdostip.zip
;    ftp://ftp.uni-stuttgart.de/pub/systems/msdos/util/system/mpdostip.zip
;                                                         .../cpi???.zip
;                                                        .../country.zip
;                                                    .../printers/necpinw.zip
;    http://www.leo.org/pub/comp/platforms/pc/msdos/utils/printutils/
;                                               .../utils/sysutils/
;                                               .../doc/
;    ftp://ftp.leo.org/...
;                ...pub/comp/platforms/pc/msdos/utils/printutils/necpinw.zip
;                                           .../utils/sysutils/country.zip
;                                           .../doc/mpdostip.zip
;
;    Last edit: 2000-10-30 MPAUL
;
; #############################################################################
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program (see LICENSE.TXT or http://www.gnu.org);
;    if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
;    Cambridge, MA 02139, USA.
;
; #############################################################################
;
;    History:
;    ========
;
;    1.00 1996       MPAUL Initial experimental release for my NEC Pinwriter
;                          P5300 (P7plus) 24 dot color printer based on my
;                          research of .CPI file formats, NLS stuff, and
;                          DOS internals.
;    1.01-1.05  1996 MPAUL Various changes and additions not filed.
;    1.06 1997-03-17 MPAUL Added support for the whole NEC Pinwriter series
;                          where applicable.
;                          (Thanks to NEC Deutschland GmbH, Ismaning (Germany),
;                          in particular Ferdinand Klement and Klaus Ulsamer
;                          at the NEC Hotline for their unbureaucratic support
;                          (01/1997-03/1997) in regard to my various questions
;                          on several NEC Pinwriters not being in my
;                          possession.  They have also provided free of charge
;                          a number of manuals for other Pinwriter models.)
;    1.07 1997-05-13 MPAUL Final version based on new NEC manuals.
;    1.08 1999       MPAUL Changes not filed.
;    1.09 2000-09-08 MPAUL Added support for PTS-DOS Code Page 667 ("Mazovia").
;                          (Thanks to Michal Tyc, Institute of Physics,
;                          Wroclaw University of Technology (Poland) for
;                          the hint that Code Page 667 is in fact "Mazovia"!)
;    1.10 2000-09-20 MPAUL Fixed a number of bugs.
;    2.00 2000-09-28 MPAUL Almost complete rewrite to restructure the source.
;                          Thereby introduction of macros to ease future
;                          maintenance.
;                          Removed my obsolete Code Page proposals 0 and 646.
;                          Added Code Page 991 ("Mazovia") as alias to 667.
;                          (Again, thanks to Michal Tyc who pointed me to
;                          Marcin Gryszkalis' Polish text converter PLC.)
;                          Added download Code Page 8501 ("Multilingual with
;                          Eurocurrency") as a variant of Code Page 850 with
;                          the Eurocurrency symbol at Code Point D5h.  This
;                          is compatible with PC DOS 7 / 2000 Code Page 850.
;                          In lack of any better assignment for this new
;                          variant by one of the "Big Players" I propose
;                          to use ID 8501 for this Code Page, which is not
;                          currently in use by IBM CDRA level 2.
;                          Added "private use" Code Pages 58194, 65280,
;                          65281..65294, 65296..65299, 65300..65305,
;                          65392..65398, 65401..65405, 65408..65410,
;                          65424..65428, 65440, 65446, 65452, 65455, 65456,
;                          65458, 65459, 65474, 65490, 65491, 65492, and
;                          65493 in the CDRA user definable ranges for CCSIDs
;                          and CPGIDs.  These allow direct access to various
;                          char sets (without offical Code Page assignments)
;                          available on the NEC Pinwriters.
;                          They are provided mainly for test purposes and
;                          not for general use.
;                          Changed NECPINW license to GPL version 2.
;    2.01 2000-09-29 MPAUL Cosmetical changes.
;    2.02 2000-10-08 MPAUL More cosmetical changes.
;                          Added conditional define CPI_STYLE for use as
;                          EPS.CPI or 4201.CPI under MS-DOS/PC DOS - still
;                          needs more work and is currently unfinished...
;                          Moved Eurocurrency matrix definitions into macros.
;                          Added Code Pages 58805, 59035, 59218, 59231, 59233,
;                          59359 in the IBM CDRA level 2 user definable range.
;                          These are variants of traditional Code Pages 437,
;                          667, 850, 863, 865, and 991, but with the French
;                          Franc symbol at Code Point 9Fh replaced by the
;                          Eurocurrency symbol. This is just to provide some
;                          form of support to the FreeDOS EUROTSR utility by
;                          Aitor Santamara.
;                          Fixed a bug visible with all the traditional
;                          Code Pages, where NECPINW.CPI would not switch
;                          back to the internal character set after a download
;                          font has been activated.  The change in the SelCP
;                          macro required the removal of a NEC specific control
;                          sequence in there (for size reasons).  This should
;                          not cause problems on old Pinwriters which all seem
;                          to support the equivalent Epson control sequence
;                          as well.
;                          Initial release for FreeDOS.
;    2.03 2000-10-10 MPAUL Corrected some typos.
;                          Added EURO_850 conditional to allow Code Page 850
;                          to provide the Eurocurrency as well.
;    2.03 2000-10-13 MPAUL Removed the SPACE padding in the footer because it
;                          saves ca. 1 Kb of disk storage space and was not of
;                          much use, anyway.  PNW VERSION and reports by my
;                          CPI.EXE will still display the info properly.
;    2.04 2000-10-15 MPAUL Added 'hidden' control sequences to make printing
;                          this file easier (currently it has 157 columns max).
;    2.04 2000-10-25 MPAUL Moved the Eurocurrency macros to separate
;                          EUROFONT.INC include file, to make exchange with
;                          other fonts easier.  For reference this file also
;                          contains a number of (printer and display) shapes
;                          NOT used by NECPINW.CPI.
;    2.04 2000-10-30 MPAUL Cosmetics.
;
; #############################################################################
;
;    DOS Compatibility:
;    ==================
;
;    NECPINW.CPI is a DOS Printer Code Page Information file designed
;    for usage with DR DOS 6.0, DR DOS "Panther" & DR DOS "StarTrek",
;    Novell DOS 7, Caldera OpenDOS 7.01, DR-OpenDOS 7.02, and DR-DOS
;    7.02 - 7.05.  Of course, it will also work under DR PalmDOS 1.0
;    when using the PRINTER.SYS from one of the other DR DOS releases
;    (DR PalmDOS itself does not ship with PRINTER.SYS).
;
;    It currently does not support other DOS issues than those listed above.
;    Older issues of DR DOS or MS-DOS/PC DOS need some adaptations or may
;    not work at all.  At the time of this writing, FreeDOS does not support
;    any .CPI files, but hopefully this will be added at a later stage and
;    probably NECPINW.CPI will than also work with FreeDOS.
;    Reports are welcome.
;
; #############################################################################
;
;    Printer compatibility:
;    ======================
;
;    The range of supported Code Pages provided by NECPINW.CPI depends on
;    the used NEC Pinwriter model and its configuration.
;
;    So far, NECPINW has been tested with a NEC P5300 (P7plus) color 24 dot
;    matrix printer, only.  Features unsupported by that printer have been
;    tested in "theory" by using the printer's hex-dump facility.  Anyway,
;    reports with other printers are most welcome...
;
;    Since the shipping NECPINW.CPI file is designed for generic use with
;    any of the supported printers, it may allow to switch to Code Pages
;    not available with your device.  Please do not select Code Pages not
;    supported by your model, as this may lead to unpredictable results.
;
;    Overview on available Code Page support with the various NEC Pinwriters:
;    ------------------------------------------------------------------------  \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
;
;    hex     CP   Name                                    P2/P3   P5/P5XL P9XL   P6/P7   P5200   P2200   P2200XE P6200   P3200   P7200     P1200 P8000
;                                                         CP2/CP3                CP6/CP7 P5300           P2plus  P6300   P3300   P7300     P1300 P72X
;                                                                                        P6plus                  P9300   P20     P3800     P2000
;                                                                                        P7plus                  P60     P30     P3900     P2Q
;                                                                                                                P70     P22Q    P62/P72   P3Q
;                                                                                                                P90     P32Q    P42Q/P52Q P2X
;
;    016Fh   367  ISO-646 (US) 7-bit                      yes     yes     yes    yes     yes     yes     yes     yes     yes     yes       yes   yes
;    01B5h   437  International, USA, IBM-2, PC-8, World Trade  yes yes   yes    yes     yes     yes     yes     yes     yes     yes       yes   yes
;    029Bh   667  Polish (Mazovia) (=CP 991)              no      no      no     no      no      no      no      8       8       8         ???   ???
;   (02E1h) (737) Greek                                   no      no      no     no      no      no      no      3 [1]   3 [1]   3 [1]     ???   ???
;    0352h   850  Multilingual, Latin I                   no      no      no     no      yes     no      no      yes     yes     yes       no??? yes???
;    0354h   852  Slavic, Eastern Europe (Latin II)       no      no      no     no      no      no      no      2,6,7,8 2,6,7,8 2,6,7,8   ???   ???
;   (0355h) (853) Turkish (Latin II)                      no      no      no     no      no      no      no      4 [1]   4 [1]   4 [1]     ???   ???
;    0357h   855  Cyrillic I                              no      no      no     no      no      no      no      1,5,6   1,5,6   1,5,6     ???   ???
;   (0359h) (857) Turkish                                 no      no      no     no      no      no      no      4 [1]   4 [1]   4 [1]     ???   ???
;    035Ch   860  Portuguese                              no      no      no     no      yes     no      no      yes     yes     yes       no??? yes???
;    035Fh   863  French Canadian                         no      no      no     no      yes     no      no      yes     yes     yes       no??? yes???
;    0361h   865  Nordic, Norway II, Danish               no      no      no     no      yes     no      no      yes     yes     yes       no??? yes???
;    0362h   866  Russian, Cyrillic II                    no      no      no     no      no      no      no      1,5,6   1,5,6   1,5,6     ???   ???
;    0363h   867  Czech??? (Kamenicky???)                 no      no      no     no      no      no      no      2 [2]   2 [2]   2 [2]     ???   ???
;    03DFh   991  Polish (Mazovia) (=CP 667)              no      no      no     no      no      no      no      8       8       8         ???   ???
;
;    2135h  8501  Multilingual, Latin I with Eurocurrency no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes [3]???
;                 (CP 850 variant with Euro at D5h)
;    E352h 58194  "" (=CP 8501)                           no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes [3]???
;
;    E5B5h 58805  (CP 437 variant with Euro at 9Fh)       no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes [3]???
;    E69Bh 59035  (CP 667 variant with Euro at 9Fh) (=CP 59359) no no???  no???  no???   8 [3]   no      no      8 [3]   no      8 [3]     no??? 8 [3]???
;    E752h 59218  (CP 850 variant with Euro at 9Fh)       no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes [3]???
;    E75Fh 59231  (CP 863 variant with Euro at 9Fh)       no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes [3]???
;    E761h 59233  (CP 865 variant with Euro at 9Fh)       no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes [3]???
;    E7DFh 59359  (CP 991 variant with Euro at 9Fh) (=CP 59035) no no???  no???  no???   8 [3]   no      no      8 [3]   no      8 [3]     no??? 8 [3]???
;
;    FF00h 65280  (0) 7-bit USA (=CP 367)                 yes     yes     yes    yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF01h 65281  (1) 7-bit France                        yes     yes     yes    yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF02h 65282  (2) 7-bit Germany                       yes     yes     yes    yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF03h 65283  (3) 7-bit UK                            yes     yes     yes    yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF04h 65284  (4) 7-bit Denmark I                     yes     yes     yes    yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF05h 65285  (5) 7-bit Sweden                        yes     yes     yes    yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF06h 65286  (6) 7-bit Italy                         yes     yes     yes    yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF07h 65287  (7) 7-bit Spain I                       yes     yes     yes    yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF08h 65288  (8) 7-bit Japan                         yes     yes     yes    yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF09h 65289  (9) 7-bit Norway I                      no      ???     ???    ???     yes     yes     yes     yes     yes     yes       yes   yes
;    FF0Ah 65290  (10) 7-bit Denmark II                   no      ???     ???    ???     yes     yes     yes     yes     yes     yes       yes   yes
;    FF0Bh 65291  (11) 7-bit Netherlands                  no      ???     ???    ???     yes     yes     yes     yes     yes     yes       yes   yes
;    FF0Ch 65292  (12) 7-bit Turkey                       no      ???     ???    ???     yes     yes     yes     yes     yes     yes       yes   yes
;    FF0Dh 65293  (13) 7-bit Spain II                     no      ???     ???    ???     yes     yes     yes     yes     yes     yes       yes   yes
;    FF0Eh 65294  (14) 7-bit Latin America                no      ???     ???    ???     yes     yes     yes     yes     yes     yes       yes   yes
;    FF10h 65296  (16) Multilingual (=CP 850)             no      ???     ???    ???     yes     no      no      yes     yes     yes       yes   yes
;    FF11h 65297  (17) Portugual (=CP 860)                no      ???     ???    ???     yes     no      no      yes     yes     yes       yes   yes
;    FF12h 65298  (18) French Canada (=CP 863)            no      ???     ???    ???     yes     no      no      yes     yes     yes       yes   yes
;    FF13h 65299  (19) Norway II (=CP 865)                no      ???     ???    ???     yes     no      no      yes     yes     yes       yes   yes
;    FF14h 65300  (20) EPROMs (e.g. CP 852, ca. CP 737,853,857) no no     no     no      no      no      no      opt.    opt.    opt.      opt.  opt.
;    FF15h 65301  (21) EPROMs (e.g. CP 866, CP 667/991)   no      no      no     no      no      no      no      opt.    opt.    opt.      opt.  opt.
;    FF16h 65302  (22) EPROMs (e.g. CP 855, CP 866)       no      no      no     no      no      no      no      opt.    opt.    opt.      opt.  opt.
;    FF17h 65303  (23) EPROMs (e.g. CP 867)               no      no      no     no      no      no      no      opt.    opt.    opt.      opt.  opt.
;    FF18h 65304  (24) EPROMs (e.g. CP 855)               no      no      no     no      no      no      no      opt.    opt.    opt.      opt.  opt.
;    FF19h 65305  (25) EPROMs (var.)                      no      no      no     no      no      no      no      opt.    opt.    opt.      opt.  opt.
;
;    FF70h 65392  DL font with Euro at D5h (universal, but ugly) no no??? no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF71h 65393  DL font with Euro at D5h (Draft 10 cpi) no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF72h 65394  DL font with Euro at D5h (Draft 12 cpi) no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF73h 65395  DL font with Euro at D5h (Draft 12 cpi HS) no   no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF74h 65396  DL font with Euro at D5h (Draft 15 cpi) no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF75h 65397  DL font with Euro at D5h (Draft 17 cpi) no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF76h 65398  DL font with Euro at D5h (Draft 20 cpi) no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF79h 65401  DL font with Euro at D5h (LQ 10 cpi)    no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF7Ah 65402  DL font with Euro at D5h (LQ 12 cpi)    no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF7Bh 65403  DL font with Euro at D5h (LQ 15 cpi)    no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF7Ch 65404  DL font with Euro at D5h (LQ 17 cpi)    no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF7Dh 65405  DL font with Euro at D5h (LQ 20 cpi)    no      no???   no???  no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;
;    FF80h 65408  Download font (default)                 128     128     128    128     yes     128     128     yes     96      yes       yes   yes
;    FF81h 65409  Download font 1                         no      yes???  yes??? yes???  128/256 no      no      128/256 no      128/256   yes   yes
;    FF82h 65410  Download font 2                         no      yes???  yes??? yes???  128     no      no      128     no      128       yes   yes
;
;    FF90h 65424  Internal fonts (default)
;    FF90h 65425  External font cardridge 1               ???     no???   yes    yes     yes     yes     yes     yes     no
;    FF91h 65426  External font cardridge 2               ???     no???   yes??? yes???  yes     no???   no???   yes     no
;    FF92h 65427  External font cardridge 3               ???     ???     ???    ???     yes     no???   no???   yes     no
;    FF93h 65428  External font cardridge 4               ???     ???     ???    ???     yes     no???   no???   yes     no
;
;    FFA0h 65440  Internal font  0 (Courier 10)           ???     no [4]  no [4] no      yes     yes     yes     yes     yes     yes       yes??? yes???
;    FFA6h 65446  Internal font  6 (Super Focus)          no???   no      no     no      no      yes     no      no      no      no???     no???  no???
;    FFACh 65452  Internal font 12 (OCR-B)                no???   no      no     no      no      yes     no      no      no      no???     no???  no???
;    FFAFh 65455  Internal font 15 (ITC Souvenir 10)      ???     no      no     no      yes     yes     yes     yes     yes???  yes       yes??? yes???
;    FFB0h 65456  Internal font 16 (Helvette 10 PT etc.)  ???     no      no     no      yes     no      yes     yes     yes???  yes       yes    yes???
;    FFB2h 65458  Internal font 18 (Times 10 PT)          ???     no      no     no [4]  yes     no      yes     yes     yes???  yes       yes    yes???
;    FFB3h 65459  Internal font 19 (New Prestige Elite 12 WP) ??? no      no     no      yes     no      yes     yes     yes???  yes       yes    yes???
;    FFC2h 65474  Internal font 34 (Bold PS)              no      no      no     no      no      no      yes     yes     no???   yes       ???    ???
;    FFD2h 65490  Internal font 50 (Fast Focus 10)        no      no      no     no      no      no      yes     no      no???   no        ???    ???
;    FFD3h 65491  Internal font 51 (Fast Focus 12)        no      no      no     no      no      no      yes     no      no???   no        ???    ???
;    FFD4h 65492  Internal font 52 (Quick Gothic 10)      no      no      no     no      no      no      no      yes     yes     yes       ???    ???
;    FFD5h 65493  Internal font 53 (Quick Gothic 12)      no      no      no     no      no      no      no      yes???  yes???  yes       ???    ???
;
;    Notes:                                                                    ////////////////////////////////////////////////////////////////////////////
;
;    [1] These Code Pages are not actually supported with EPROMs #3/#4,
;        but only a small number of Code Points differ between the
;        EPROM fonts and the official Code Pages.  Hence I decided to at
;        least add partial support for these Code Pages.
;
;        CP:  Differences compared to the EPROM implementation:
;
;        737  EEh, F0h, F1h, F4h, F5h, FCh.
;        853  86h, 8Fh, 91h, 92h, 9Bh, 9Dh, A8h, A9h, ACh, ADh,
;             B5h..B8h, BDh, BEh, C6h, C7h, CFh..D8h, DDh, DEh, ...
;        857  9Bh, 9Dh, A9h, B5h..B8h, BDh, BEh, C6h, C7h, CFh..D8h,
;             DDh, DEh, ...
;
;    [2] I assigned Kamenicky to Code Page 867, because some original NEC
;        advertisment flyers mentioned, that Code Page 867 would be supported
;        by one of the optional EPROMs (they said nothing about the supported
;        language, though).  From other sources I have hints that Code Page
;        867 is Czech, hence it seems a good assumption for Code Page 867
;        is Kamenicky.  Info wanted...
;
;    [3] Code Pages 8501 and 58194 are variants of Code Page 850, but with the
;        Eurocurrency symbol at Code Point D5h.  PC DOS 7 - 2000 provides
;        this revised Code Page under the name 850, but I decided to
;        leave the traditional Code Page 850 alone as the old definition
;        is still in use in most of the other DOS operating systems.
;        My proposal for the Euro-variant of Code Page 850 is Code Page 8501,
;        while the IBM CDRA level 2 standard reserves the range E000h..EFFFh
;        for user definable CCSIDs (that is, "Code Pages" here).  NECPINW.CPI
;        provides the Code Page under both IDs.  Please note, that both
;        assignments are subject to change in the case this Code Page would
;        get an offical Code Page number in the future.
;        The printer must be set up to accept a 256 character download
;        font (check print buffer settings etc.).
;        To provide some level of support to the FreeDOS EUROTSR extension,
;        I introduced variants of Code Pages 437, 667/991, 850, 863, and 865
;        under IDs 58805, 59035/59359, 59218, 59231, and 59233. They replace
;        the French Franc symbol at Code Point 9Fh by the Eurocurrency symbol.
;        Unfortunately download fonts are bound to specific printer modes,
;        and it is not possible to properly define a character for all
;        possible resolutions at the same time.
;        For now ("EURO_STYLE EQU 9"), the Eurocurrency symbol is defined
;        for Letter Quality (LQ), 10 cpi (Pica) which seems to be the
;        most commonly used setting.
;        Alternatively the char sets with Eurocurrency at D5h are available in
;        Draft 10..20 cpi under IDs 65393..65398 and in LQ 10..20 cpi under
;        IDs 65401..65405, whereby ID 65401 is again LQ 10 cpi (Pica).
;        Under ID 65392 you can use the download data for Draft in any mode,
;        including all the LQ modes.  In contrast to the above said, this
;        allows to have *one* definition that will be printed in *any*
;        resolution, however, it looks very ugly in LQ modes, and columns
;        are no longer aligned, too.  If you still want this universal
;        setting to become the default, please edit this to "EURO_STYE EQU 0".
;        This will change the default for Code Pages 8501, 58194, 58805,
;        59035/59359, 59218, 59231, and 59233. No variants of Code Pages
;        58805, 59035/59359, 59218, 59231, and 59233 with forced font sizes
;        are available.
;
;    [4] Because the corresponding printer supports only the mentioned
;        type face (in LQ mode), it is not selectable.
;
;      - An EPROM-number instead of just 'yes' indicates that these Code Pages
;        are only supported with the corresponding additional EPROM installed
;        to the NEC Pinwriter (see table below).
;        Unfortunately Code Pages 852, 855, and 866 are not supported by all
;        available EPROMs, and Code Pages 855 and 866 have different selection
;        IDs with different EPROMs.
;        By default NECPINW.CPI supports the EPROMs #5/#6 "Code Tables"
;        ("EPROM_NO EQU 6"). Support for the other EPROMs, however, is
;        selectable at compilation time (EPROM_NO).  Note, that not all fonts
;        may be supported in these extra Code Pages (see tables below).
;
;      - A 128 or 256 size instead of just 'yes' indicates that the printer's
;        download RAM buffer may hold only 128 or 256 characters in this
;        mode of operation.
;
;      - The IBM CDRA level 2 standard reserves Code Page IDs FF00h..FFFEh
;        for user definable "private use" assignments.  Hence I introduced
;        a number of pseudo-Code Pages to directly address all code sets
;        available with the various NEC Pinwriters.  Just add the NEC char set
;        selection IDs in the range 0..14, 16..19, and 20..25 (decimal)
;        to the FF00h base resulting in 65280..65305.  This allows to use
;        code sets not even assigned to one of the offical Code Page IDs,
;        e.g. the "7-bit German" char set (2) is available under ID 65282
;        (FF02h) or - provided the proper EPROM installed to your printer -
;        the "CWI" code set (EPROM #7 "Hungary") can be found under ID 65301
;        (FF15h).
;        While these must not necessarily reflect actual different code sets,
;        65392..65405 selects the Eurocurrency char set (with the Euro at D5h)
;        in different resolutions, Code Page assignments 65408..65410 allow
;        to select one of the download fonts (default, 1, or 2), 65424..65448
;        allow to switch between internal fonts and one of the four external
;        cardridge fonts, and 65440, 65446, 65452, 65455, 65456, 65458, 65459,
;        65474, 65490, 65491, 65492, or 65493 activate one of the internal
;        fonts (e.g. 65459 selects "New Prestige Elite 12 WP" which
;        significantly differs in the supported range of characters).
;        These are mainly provided for test purposes and not for general use.
;        Please note, that these numbers are NECPINW.CPI and printer specific
;        and are not supported by other devices or software.  Furthermore,
;        by definitionem other software may use these numbers for other
;        purposes, so you must not assume to get the same results elsewhere.
;
;      - For Code Page support fully meeting the official specifications, the
;        printer must not be set to the internal font "Prestige Elite 12 WP"
;        nor to any other incompatible download or cardridge font (see above),
;        since these fonts use a code set with major differences compared to
;        IBM-2 (which is Code Page 437 in this respect).
;        Speaking of "Prestige Elite 12 WP": While the lower half of the
;        code set is identical, this font has many special symbols in the
;        upper half, which cannot be found in Code Page 437 nor in any other
;        Code Page (some can be found in Epson's ISO-646 country specific
;        subset of "US Legal", but at different Code Points).  Code Page
;        switching is still functional when using this font, but only
;        those Code Points are replaced with the correct shapes, which
;        differ between the country specific code set to be set and
;        Code Page 437.
;        In other words, you can think of the printer 'assuming' the
;        font's base plane (the setting assigned to Code Page 437) would
;        actually be Code Page 437; so, when switching Code Pages, it has
;        to replace only those characters, which differ between these
;        Code Pages.  However, for unknown reasons the font's base plane
;        is very different from Code Page 437 and any other Code Page.
;        As a matter of this fact, you will get better results in any
;        Code Page other than 437 (since more Code Points are matching),
;        but still many shapes differ from the Code Page to be set.
;        NECPINW.CPI could have been designed to avoid this by switching
;        back to a default font (most often "Courier" or "DRAFT Gothic")
;        each time a new Code Page is set or refreshed.  The obvious backdraw
;        would be, that users usually printing in fonts other than the
;        default font would need to re-select their alternative font
;        after each and any Code Page switch.  Currently, NECPINW.CPI does
;        not change the active font selection whenever possible (exceptions
;        are download Code Pages like 8501 and entries which explicitly
;        require a font or mode switch).
;
;      - You should not use NECPINW.CPI with the first three generations of
;        NEC Pinwriters (P2/P3, CP2/CP3, P5/P5XL, P9XL, P6/P7, CP6/CP7),
;        because these printers do not support Code Page switching at all.
;        Only download fonts would help to get rid of this restriction.
;        (The P5/P5XL, P9XL, P6/P7 and CP6/CP7 may at least support the
;        download Code Page 8501, and probably also some of the entries in
;        the user definable range, but since I don't have any detailed info
;        on these early printers, and the later NEC manuals are somewhat
;        ambiguous in regard to which printers support which control
;        sequences, I am not completely sure about this.  Info wanted.)
;
;      - Also, I have no further information regarding the latest generation
;        of NEC Pinwriters P1200/P1300 (P2Q/P3Q), P2000 (P2X), and
;        P8000 (P72X), but I assume, that they can be compared best with
;        their pre-decessors.
;
;      - Internal font 16 ("Helvette 10 PT") is named "S. Helvetica" for
;        the P20/P30, P60/P70, P90.
;
;    Overview on available optional EPROMs for various NEC Pinwriters:
;    -----------------------------------------------------------------         \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
;
;     No Name       Rev kBit  Selection ID                                          Supported by models      Supported in fonts
;                             20       21      22       23        24     25
;     #1 Russian     R5  512  Russian  Extruss 866      Baltic    855    --         all Pinwriters w/ EPROM  Courier, Draft, Bold PS
;     #2 East Europe R4  512  852      Balkan  Hungary  Kamenicky Polish Yugoslavia all Pinwriters w/ EPROM  all resident fonts (except Prestige Elite WP)
;     #3 Greek       R4  512  Greek    --      --       --        --     --         all Pinwriters w/ EPROM  Courier, Draft, Bold PS, Times PS, Helvetica PS
;     #4 Turkey      R1  512  Turkey   --      --       --        --     --         all Pinwriters w/ EPROM  all resident fonts (except Prestige Elite WP)
;     #5 Code Tables R3  512  852      866     855      --        --     --         all Pinwriters w/ EPROM  Courier, Draft, Bold PS, Times PS, Helvetica PS,
;                                                                                                            ITC Souvenir, Quick Gothic, LQ S/S, Draft S/S
;     #6 Code Tables R3 1024  852      866     855      --        --     --         P62, P72, P42Q, P52Q     all resident fonts (except Prestige Elite WP)
;     #7 Hungary     R1  512  852      CWI     --       --        --     --         all Pinwriters w/ EPROM  all resident fonts (except Prestige Elite WP)
;     #8 Polish      R1  512  852      Mazovia Polish_7 --        --     --         all Pinwriters w/ EPROM  all resident fonts (except Prestige Elite WP)
;     #9 ORC-BDR     R2  512  ORC-BDR  --      --       --        --     --         P20, P30, P60, P70, P90, Courier (P20, P30, P22Q, P32Q, P42Q, P52Q),
;                                                                                   P22Q, P32Q, P42Q, P52Q   ITC Souvenir (P60, P70, P90)
;    #10 Bank        R1  512  USA_Bank --      --       --        --     --         all Pinwriters w/ EPROM  all resident fonts (except Prestige Elite WP)
;
;    Notes:                                                                    //////////////////////////////////////////////////////////////////////////////
;
;      - EPROM #7 "Hungary" and ID 22 "Hungary" in EPROM #1 "Russian"
;        are named "Hungaria" in the original NEC manuals.
;
;      - Fonts for EPROM #2 ID 24 "Polish" and EPROM #8 ID 22 "Polish_7"
;        are identical.  BTW, the fonts differ from Code Page 437 only in
;        chars below 80h.
;
;      - Code Page #8 ID 21 "Mazovia" is Code Page 667 under PTS-DOS & S/DOS.
;        It is named Code Page 991 by PLC author Marcin Gryszkalis
;        (PLC is a Polish text converter).  Both assignments don't seem
;        to be Code Page assignments approved by IBM or Microsoft.
;
;    Overview on NEC Pinwriter EPROM support:
;    ----------------------------------------                                  \\\\\\\\\\\\
;
;    Printer model           kBit      PCB Revision                   Firmware
;
;    P3200/P3300, P20/P30    512       all                            since FW17
;                                      (until C5 in 1024 kBit socket)
;    P6200/P6300, P60/P70    512       since B8                       since FW20.04
;    P9300, P90              512       since A2                       since FW13.01
;    P7200/P7300, P62/P72    1024/512  cp: all                        cp: all
;                                      font: new version 1993         font: FW 12
;    P22Q/P32Q               512       all                            all
;    P3800/P3900, P42Q/P52Q  1024/512  cp: all                        cp: all
;                                      font: all                      font: since June 1993
;
;    Notes:                                                                    ////////////
;
;      - The NEC Pinwriters P2/P3, CP2/CP3, P5/P5XL, P9XL, P6/P7, CP6/CP7,
;        P2200, P2200XE (P2plus), and P5200/P5300 (P6plus/P7plus) don't
;        provide any special EPROM support.
;
; #############################################################################
;
;    Installation under DOS:
;    =======================
;
;    Example:
;
;        CONFIG.SYS:
;
;          COUNTRY=49,437,C:\DRDOS\COUNTRY.SYS
;          DEVICE|HIDEVICE|DEVICEHIGH=...\PRINTER.SYS PRN=(1050,999,2)
;
;        AUTOEXEC.BAT:
;
;          MODE PRN: CODEPAGE PREPARE=((437,850) ...\NECPINW.CPI)
;          [LH] NLSFUNC C:\DRDOS\COUNTRY.SYS
;          CHCP 437
;
;    Notes:
;
;      - In this example we use country code 49 (Germany) and corresponding
;        Code Pages 437 and 850.  Please change this to your requirements.
;
;      - We use a dummy hardware Code Page 999 here to force PRINTER.SYS
;        to actually send the control sequences from the NECPINW.CPI file
;        for *both* Code Pages 437 and 850, rather then using an internally
;        fixed control sequence for the hardware Code Page when switching
;        to 437.  This sequence would be valid for the Epson FX-850/
;        FX-1050 printer (in the case of the "1050" type), but not for
;        the NEC Pinwriters.
;
;      - If your COUNTRY.SYS file (as it is used by NLSFUNC) supports
;        Code Page {cpid} for your country (normally 437 and 850 for
;        Germany = 49), you are now able to change the Code Page for the
;        system and all devices with Code Page support installed by issuing
;
;          CHCP {cpid}
;
;        However, this way you cannot switch to the other Code Pages
;        supported by NECPINW.CPI (but not supported by COUNTRY.SYS for
;        your country).  To select a random Code Page supported by your
;        printer and by NECPINW.CPI, you have to use somewhat more complex
;        DOS commands instead:
;
;          MODE PRN: CODEPAGE PREPARE=(({cpid}) ...\NECPINW.CPI)
;          MODE PRN: CODEPAGE SELECT={cpid}
;
;        This will replace the 1st slot (which has been assigned to 437
;        before) by the new Code Page {cpid}.  If you would like to replace
;        the 2nd slot, just add a comma in front of {cpid}.  Note, that
;        these commands do not change the active Code Page for other
;        devices nor the display.
;
;      - For additional information on how to install DOS Code Page support,
;        please refer to DOS user manuals (HELP, DOSBOOK, etc.) or consult
;        my comprehensive NWDOSTIP.TXT document from my tips & tricks
;        package MPDOSTIP.ZIP (available in German language only).
;
; #############################################################################
;
;    Implementation details:
;    =======================
;
;    Notes:
;
;      - For details on DOS Code Page support, Code Page ID references,
;        and .CPI file formats, have a look at my DOS .CPI and Linux
;        .CP file analyzer and decompiler package CPI???.ZIP, also
;        part of FreeDOS.  For details on DOS country support, country
;        ID references, and COUNTRY.SYS file formats, have a look at
;        my COUNTRY.ZIP/CHCC???.ZIP package.  (The most current pre-views
;        on future versions are available on email request.)
;
;      - I wished I could have designed NECPINW.CPI as a native Code Page
;        switching printer .CPI file (PRINTER_TYPE 2), as this would consume
;        less memory in the resident PRINTER.SYS driver.  Unfortunately,
;        PRINTER.SYS partially uses hardwired escape sequences for
;        PRINTER_TYPE 2, so that they are not available for redefinition
;        in a .CPI file (this holds true at least for DR DOS, but probably
;        also for MS-DOS/PC DOS).  This is why NECPINW.CPI is implemented as
;        a download printer .CPI file (PRINTER_TYPE 1), although with a few
;        exceptions the sent data is not font data, but just control
;        sequences for Code Page switching between ROM fonts.  The exceptions
;        are download Code Pages like 8501 (and the other Euro variants),
;        which actually makes use of the RAM font feature to define the shape
;        for the Eurocurrency.
;        DR DOS supports two model variants for PRINTER_TYPE 1, "4201" for
;        the IBM Proprinters II & III Model 4201 and IBM Proprinters II & III
;        XL Model 4202, and "1050" for the Epson printers FX-850/FX-1050.
;        I used "1050" instead of "4201" to take advantage of the smaller
;        resident size for the buffer occupied by PRINTER.SYS for download
;        data (ca. 2.3 Kb in contrast to ca. 7 Kb per Code Page).  Due to
;        this fixed allocation, a ca. 2-2.5 Kb data area is still wasted
;        for each prepared Code Page (typically two).  This problem could
;        be solved only by adding a user definable printer type to
;        PRINTER.SYS (Idea: loading the escape sequences in XMS, EMS,
;        or directly from harddisk; and a PRINTER.SYS parameter to define
;        the size of download data)...  Something to do for FreeDOS and
;        a possibly future "open" DR-DOS...
;        Another reason for not using the "4201" type is the fact, that
;        some of the escape sequences (in the CPData macro) are stored
;        in yet another sub-format, which I have not completely decoded
;        at present.
;
;    How to build:
;    -------------
;
;        1. Select appropriate conditional assembly switches in NECPINW.ASM.
;        2. Run MAKENEC.BAT, that is:
;
;           TASM NECPINW.ASM, NECPINW.OBJ, NUL, NUL
;           LINK NECPINW.OBJ; NECPINW.EXE; NUL; NUL
;           EXE2BIN NECPINW.EXE NECPINW.CPI
;
;        Tested with TASM 3.1 and MASM 5.1 only.  MASM 4.0 needs adaptations.
;        Reports with other versions are welcome.
;
;    ToDo list:
;    ----------
;
;      - More testing with other printer models and DOS versions!
;        Finish CPI_STYLE conditional define for non-DR DOS styles.
;
;      - Still to test are *expanded* Draft and LQ modes. Since the
;        condensed modes required different box sizes for the Eurocurrency
;        symbol definition, the same might hold true for the expanded
;        modes...  This would require changes in the definition of the
;        Eurocurrency symbol or additional entries...
;
;      - Make specific printer models selectable at compilation time to
;        allow creation of .CPI files which strictly support features of
;        a particular model only (PRINTER_MODEL & EPROM_STYLE).  Thereby
;        revise all the model specific control sequences to be actually
;        valid for the corresponding printers (unfortunately the NEC manuals
;        are somewhat ambiguous in regard to this question).
;
;        If you own one of the following NEC Pinwriter models (P2/P3,
;        CP2/CP3, P5/P5XL, P9XL, P6/P7, CP6/CP7, P2200 (not P2200XE),
;        P6200/P6300 (P60/P70), P9300 (P90), P22Q/P32Q, P3800/P3900
;        (P42Q/P52Q), P1200/P1300 (P2Q/P3Q), P2000 (P2X), or P8000 (P72X))
;        it would be really great, if you could get into contact with me,
;        so that I can verify some of the assumptions I had to make when
;        developing NECPINW.CPI by checking them with your manuals.
;        I need information about what kind of download font (count and
;        size), cardridge fonts (slot count and selection count), and
;        internal fonts (name and IDs) are actually supported by your
;        printer.  I would also need to check some of the control sequences.
;
;      - Do we need to take special precautions for printers on 7-bit-only
;        serial connections?  Do we have to use "ESC_,'>'", "ESC_,'='", and
;        "ESC_,'#'" for them?
;
;      - It seems some Epson printers allow to re-define characters above
;        128 even though the DL font buffer can hold 128 chars only.
;        As far as I know, the NEC Pinwriters do not have any such facility,
;        forcing us to use a 256 char DL font buffer.  If there would be a
;        method to use only a 128 char DL buffer even for chars above 128,
;        we should switch to this method because it would reduce NECPINW.CPI's
;        dependencies on the printers' configuration.  Does anybody know?
;
;      - Support for other Code Pages by download fonts and improving support
;        for Code Pages 737, 853, 857.  (Problem would be the large size of
;        the download data and different formats of download data in different
;        printer modes.)  We'd have to do alot of case decisions and cannot
;        create a generic .CPI file (see Code Page 8501 and its variants).
;        Please send me your FreeWare or Public Domain download fonts.
;
;      - Similar .CPI files for other printers to be added (an implementation
;        for the Epson LQ-570+/LQ-1070+ dot matrix printers already exists)...
;
;      - Please send all corrections, changes, fixes, or enhancements to me,
;        rather than distributing modified versions of this software.
;
; #############################################################################


VERSION_MSG     equ     <"2.04">        ; file version
DATE_MSG        equ     <"001030">      ; 6 digit date (ISO 28601/ISO 8601 "yymmdd")

;PRINTER_MODEL  equ     0    NYI!!!     ; <0>= generic file for all possible models
                                        ;  1..xx = support specific model only

;EPROM_STYLE    equ     0    NYI!!!     ; <0>= support as much as possible, but
                                        ;      take EPROM_NO into account
                                        ;  1 = support *only* EPROM_NO

EPROM_NO        equ     6               ;  0 = none
                                        ;  1 = Russian
                                        ;  2 = East Europe
                                        ;  3 = Greek
                                        ;  4 = Turkey
                                        ;  5 = Code Tables (512 Kb)
                                        ; <6>= Code Tables (1 Mb)
                                        ;  7 = Hungaria
                                        ;  8 = Polish
                                        ;  9 = ORC-BDR
                                        ; 10 = BANK

EURO_STYLE      equ     9               ;  0 = Universal (any mode, but ugly)
                                        ;  1 = Draft 10 cpi (Pica)
                                        ;  2 = Draft 12 cpi (Elite)
                                        ;  3 = Draft 12 cpi HS (Elite)
                                        ;  4 = Draft 15 cpi (Micro)
                                        ;  5 = Draft 17 cpi (Pica+Condensed)
                                        ;  6 = Draft 20 cpi (Elite+Condensed)
                                        ; <9>= LQ 10 cpi (Pica)
                                        ; 10 = LQ 12 cpi (Elite)
                                        ; 11 = LQ 15 cpi (Micro)
                                        ; 12 = LQ 17 cpi (Pica+Condensed)
                                        ; 13 = LQ 20 cpi (Elite+Condensed)

;TYPE_FACE      equ     255  NYI!!!     ; 0  = Courier 10
                                        ; 6  = Super Focus (P2200 only)
                                        ; 12 = OCR-B (P2200 only)
                                        ; 15 = ITC Souvenir 10
                                        ; 16 = Helvette 10 PT
                                        ; 18 = Times 10 PT
                                        ; 19 = New Prestige Elite 12 WP
                                        ; 34 = Bold PS
                                        ; 50 = Fast Focus 10
                                        ; 51 = Fast Focus 12
                                        ; 52 = Quick Gothic 10
                                        ; 53 = Quick Gothic 12
                                        ;<255>= no forced type face

;QUAL_STYLE     equ     0    NYI!!!     ; <0>= no forced quality
                                        ;  1 = force Draft quality
                                        ;  2 = force LQ

CPI_STYLE       equ     0               ; <0>= DR DOS 6.0+ 1050.CPI file
                                        ;  1 = PC DOS 6.1+ EPS.CPI file (NYI!!!)
                                        ;  2 = MS-DOS/PC DOS 3.3+ 4201.CPI (NYI!!!)
                                        ;  3 = future DR-DOS 7+ NECPINW.CPI file
                                        ;      may also be used for FreeDOS (NYI!!!)

EURO_850        equ     0               ; <0>= CP 850 without Euro, use CP 8501 instead
                                        ;  1 = CP 850 is same as CP 8501

DEBUG           equ     0               ; <0>= generate distribution .CPI file
                                        ;  1 = include a few more test codes

; #############################################################################

        include eurofont.inc

        PAGE    ,160

; #############################################################################

FILE_NAME       equ     <"NECPINW.CPI"> ; .CPI filename

NUL             equ     00h             ; special characters
LF              equ     0Ah             ;
CR              equ     0Dh             ;
SI_             equ     0Fh             ; "shift in" condensed script on
DC2             equ     12h             ; "device control" condensed script off
CTLZ            equ     1Ah             ;
ESC_            equ     1Bh             ; escape sequence (ESC/P, IBM, NEC)
FS_             equ     1Ch             ; escape sequence lead-in (NEC)
SPACE           equ     20h             ;
LTERM           equ     24h             ;

CP667           equ     667             ; unofficial Code Page assignments
CP867           equ     867             ; for easier redefinition...
CP991           equ     991             ;
CP8501          equ     8501            ;

DEVICE_TYPE     equ     2               ; 1 = display, 2 = printer
IF CPI_STYLE EQ 1                       ; NB. Must be SPACE padded to 8 chars!
DEVICE_NAME     equ     <"EPS",SPACE,SPACE,SPACE,SPACE,SPACE> ; PC DOS 6.1+
ELSEIF CPI_STYLE EQ 2
DEVICE_NAME     equ     <"4201",SPACE,SPACE,SPACE,SPACE>      ; MS-DOS/PC DOS
ELSEIF CPI_STYLE EQ 3
DEVICE_NAME     equ     <"NECPINW",SPACE> ; reserved: future DR-DOS 7+ / FreeDOS
ELSE
DEVICE_NAME     equ     <"1050",SPACE,SPACE,SPACE,SPACE>      ; DR DOS 6.0+
ENDIF

FONT_TYPE       equ     1               ;

PRINTER_TYPE    equ     1               ; 1 = download printer

NO_FONTS        equ     1               ; count of fonts

ITALICS         equ     0               ; use Italics for chars > 127
GRAPHICS        equ     1               ; use IBM graphics for chars > 127

                                        ; Standard Char Set selection IDs:
ID_0            equ     0               ; "7-bit US"
ID_1            equ     1               ; "7-bit France"
ID_2            equ     2               ; "7-bit Germany"
ID_3            equ     3               ; "7-bit United Kingdom"
ID_4            equ     4               ; "7-bit Denmark I"
ID_5            equ     5               ; "7-bit Sweden"
ID_6            equ     6               ; "7-bit Italy"
ID_7            equ     7               ; "7-bit Spain I"
                                        ; Extended Char Set selection IDs:
ID_8            equ     8               ; "7-bit Japan"
ID_9            equ     9               ; "7-bit Norway I"
ID_10           equ    10               ; "7-bit Denmark II"
                                        ; NEC specific Char Set selection IDs:
ID_11           equ    11               ; "7-bit Netherlands" (11 = "Spain II" with Epson!!!)
ID_12           equ    12               ; "7-bit Turkey"      (12 = "Latin America" with Epson!!!)
ID_13           equ    13               ; "7-bit Spain II"    (13 = "Korea" with Epson!!!)
ID_14           equ    14               ; "7-bit Latin America"
IF DEBUG EQ 1
ID_15           equ    15               ; (not used)         
ENDIF
                                        ; NEC specific Code Page selection IDs:
ID_16           equ    16               ; "Multilingual" (CP 850)
ID_17           equ    17               ; "Portugual" (CP 860)
ID_18           equ    18               ; "French Canada" (CP 863)
ID_19           equ    19               ; "Norway II" (CP 865)
                                        ; NEC specific EPROM char set selection IDs:
ID_20           equ    20               ; CP 852,
                                        ; ca. CPs 853 and 857 (#4 "Turkish"),
                                        ; ca. CP 737 (#3 "Greek").
ID_21           equ    21               ; CPs 667/991 "Mazovia" (#8 "Polish"),
                                        ; CP 866 (#5/#6 "Code Tables").
ID_22           equ    22               ; CP 855 (#5/#6 "Code Tables"),
                                        ; CP 866 (#1 "Russian").
ID_23           equ    23               ; CP 867 (#2 "East Europe")
ID_24           equ    24               ; CP 855 (#1 "Russian")
ID_25           equ    25               ;
IF DEBUG EQ 1
ID_26           equ    26               ; (not used)
ID_64           equ    64               ; (64 = "Legal" with Epson!!!)
ENDIF
                                        ; Script family type face selector
TF_COURIER_10   equ     0               ; 0 = Courier 10
TF_SUPERFOCUS   equ     6               ; 6 = Super Focus (P2200 only)
TF_OCR_B        equ    12               ; 12= OCR-B (P2200 only)
TF_ITCSOUVENIR_10 equ  15               ; 15= ITC Souvenir 10
TF_HELVETTE_10PT equ   16               ; 16= Helvette 10 PT
TF_TIMES_10PT   equ    18               ; 18= Times 10 PT
TF_NEWPRESTIGEELITE_12WP equ 19         ; 19= New Prestige Elite 12 WP
TF_BOLD_PS      equ    34               ; 34= Bold PS
TF_FASTFOCUS_10 equ    50               ; 50= Fast Focus 10
TF_FASTFOCUS_12 equ    51               ; 51= Fast Focus 12
TF_QUICKGOTHIC_10 equ  52               ; 52= Quick Gothic 10
TF_QUICKGOTHIC_12 equ  53               ; 53= Quick Gothic 12

BUFFER_NO       equ     0               ; since we need a 256 byte buffer, only
                                        ; buffer 1 (BUFFER_NO = 0) is valid

SUB_LENGTH      equ     5

EURO_CHR_FD     equ     9Fh             ; Code Point for Euro (FreeDOS EUROTSR)
EURO_CHR_850    equ    0D5h             ; Code Point for Euro (PC DOS 7 CP 850)
                                        ; NB. A number of other Code Pages,
                                        ; which, however, are not supported
                                        ; by NECPINW.CPI have the Eurocurrency
                                        ; symbol at Code Points 80h or 88h.

QUAL_ANY        equ     0               ; for use with SelCPI macro
QUAL_DRAFT      equ     1               ;
QUAL_LQ         equ     2               ;
                                        ;
IF EURO_STYLE GE 9                      ; defines quality of
QUAL_FD         equ     QUAL_LQ         ; FreeDOS EUROTSR Eurocurrency support
ELSEIF EURO_STYLE LE 6                  ;
QUAL_FD         equ     QUAL_DRAFT      ;
ELSE                                    ;
QUAL_FD         equ     QUAL_ANY        ;
ENDIF                                   ;

CPI_ANY         equ     0               ; for use with SelCPI macro
CPI_10          equ    10               ;
CPI_12          equ    12               ;
CPI_12HS        equ   255               ;
CPI_15          equ    15               ;
CPI_17          equ    17               ;
CPI_20          equ    20               ;
                                        ;
IF EURO_STYLE EQ 1                      ; defines resolution of
CPI_FD          equ     CPI_10          ; FreeDOS EUROTSR Eurocurrency support
ELSEIF EURO_STYLE EQ 2                  ;
CPI_FD          equ     CPI_12          ;
ELSEIF EURO_STYLE EQ 3                  ;
CPI_FD          equ     CPI_12HS        ;
ELSEIF EURO_STYLE EQ 4                  ;
CPI_FD          equ     CPI_15          ;
ELSEIF EURO_STYLE EQ 5                  ;
CPI_FD          equ     CPI_17          ;
ELSEIF EURO_STYLE EQ 6                  ;
CPI_FD          equ     CPI_20          ;
ELSEIF EURO_STYLE EQ 9                  ;
CPI_FD          equ     CPI_10          ;
ELSEIF EURO_STYLE EQ 10                 ;
CPI_FD          equ     CPI_12          ;
ELSEIF EURO_STYLE EQ 11                 ;
CPI_FD          equ     CPI_15          ;
ELSEIF EURO_STYLE EQ 12                 ;
CPI_FD          equ     CPI_17          ;
ELSEIF EURO_STYLE EQ 13                 ;
CPI_FD          equ     CPI_20          ;
ELSE                                    ;
CPI_FD          equ     CPI_ANY         ;
ENDIF                                   ;

LAST            equ     1               ; for use with CPEntry macro
NOTLAST         equ     0               ;

CPEntry macro   start,next,codepage,data,flag
        ENTRY_COUNTER = ENTRY_COUNTER + 1
start   dw      (offset next - offset start)
IF flag EQ LAST
        ;;dd    0                       ; Last Code Page
        dw      0, 0                    ; End of List marker
ELSE
        ;;dd    offset next             ; File offset of next list entry
        dw      offset next             ;
        dw      0                       ; (segment always zero)
ENDIF
        dw      DEVICE_TYPE             ; Device number
        db      DEVICE_NAME             ; Device name
        dw      codepage                ; Code Page number
        dw      3 dup (0)               ; Reserved

        ;;dd    offset data             ; File offset of data-header for this
        dw      offset data             ;
        dw      0                       ; (segment always zero)

IF flag EQ LAST
ELSE
next    label   word                    ; to avoid improper use of the macro...
ENDIF
        endm


SelCP   macro   mode,selector           ; used for Code Page selection
                                        ; BEWARE: This must be 12 bytes long!!!
        db      ESC_,'%',0              ; select internal char set
                                        ;
        db      ESC_,'t',mode           ; choose "Italics" or "Graphics" table
                                        ; NB. The previous is probably not
                                        ; supported by P5XL,P9XL,P6/P7/CP6/CP7!
                                        ;
        ;db     FS_,'I',mode            ; same as above (NEC only)
        ;                               ; NB. The previous is probably not
        ;                               ; supported by P5XL,P9XL,P6/P7/CP6/CP7!
                                        ;
        db      ESC_,'R',selector       ; select character set
        db      NUL                     ; dummy filler
        db      ESC_,'6'                ; codes 128-159 are printable
                                        ; NB. The previous is probably not
                                        ; supported by P5XL,P9XL,P6/P7/CP6/CP7!
        endm


CPData  macro   start,next,mode,selector,fontdata
start   dw      FONT_TYPE               ; type of font (1=FONT)
        dw      NO_FONTS                ; count of fonts
        dw      (offset next - offset fontdata) ; Length of font definitions
fontdata label  BYTE
        dw      PRINTER_TYPE
        dw      12                      ; length of sequences
                                        ; NB. Apparently, DR DOS PRINTER.SYS
                                        ; uses the second half of the 1st
                                        ; sequence as lead out sequence???
                                        ; For proper results, you may not
                                        ; move the starting points of these
                                        ; sequences.

IF CPI_STYLE EQ 1                       ; PC DOS 6.1+ EPS.CPI (NYI!!!)

        db      SUB_LENGTH              ; length of sub-sequence 1
        db      ESC_,'%',0              ; init sequence 1
        db      ESC_,6                  ;
        db      SUB_LENGTH              ; length of sub-sequence 2
        db      ESC_,'%',1              ; init sequence 2
        db      ESC_,6                  ;
        ; more control sequences immediately following the CPData macro...
        SelCP   mode,selector           ; actual init sequence (RAM)

ELSEIF CPI_STYLE EQ 2                   ; MS-DOS/PC DOS 4201.CPI (NYI!!!)

        db      SUB_LENGTH              ; length of sub-sequence 1
        db      SUB_LENGTH dup (NUL)    ; dummy for init sequence 1
        db      SUB_LENGTH              ; length of sub-sequence 2
        db      SUB_LENGTH dup (NUL)    ; dummy for init sequence 2
        ; more control sequences immediately following the CPData macro...
        ;db     32-2*SUB_LENGTH dup (NUL); dummy
        SelCP   mode,selector           ; actual init sequence (RAM)

ELSE                                    ; DR DOS 6.0+ 1050.CPI (and future
                                        ; DR-DOS 7+/FreeDOS NECPINW.CPI)
        SelCP   mode,selector           ; init sequence 1 (ROM)
        SelCP   mode,selector           ; init sequence 2 (RAM)
        ; more control sequences immediately following the CPData macro...

ENDIF
        endm


EuroDraft10     macro euro_sym
        ;       Definition of the Eurocurrency symbol for Draft 10 cpi (Pica):
        ;       (currently same as Universal):
        ;
        ;       123456789012            LEAD_IN+BOX_SIZE+LEAD_OUT=12 (!)
        ;         123456789             BOX_SIZE=9 here (9 max.)
        ;       12         1            LEAD_IN=2, LEAD_OUT=1 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,2,9,1
        EURO_PRN_24x9_Draft             ; RAM data for character (3*9 bytes)
        endm


EuroDraft12     macro euro_sym
        ;       Definition of the Eurocurrency symbol for Draft 12 cpi (Elite):
        ;
        ;       123456789012345         LEAD_IN+BOX_SIZE+LEAD_OUT=15 (!)
        ;          123456789            BOX_SIZE=9 here (9 max.)
        ;       123         123         LEAD_IN=3, LEAD_OUT=3 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,3,9,3
        EURO_PRN_24x9_Draft             ; RAM data for character (3*9 bytes)
        endm


EuroDraft12HS   macro euro_sym
        ;       Definition of the Eurocurrency symbol for Draft HS 12 cpi (Elite):
        ;
        ;       12345678901             LEAD_IN+BOX_SIZE+LEAD_OUT=10 (!)
        ;        123456789              BOX_SIZE=9 here (9 max.)
        ;       1                       LEAD_IN=1, LEAD_OUT=0 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,1,9,0
        EURO_PRN_24x9_Draft             ; RAM data for character (3*9 bytes)
        endm


EuroDraft15     macro euro_sym
        ;       Definition of the Eurocurrency symbol for Draft 15 cpi (Micro):
        ;
        ;       1234567890123456        LEAD_IN+BOX_SIZE+LEAD_OUT=16 (!)
        ;           123456789           BOX_SIZE=9 here (9 max.)
        ;       1234         123        LEAD_IN=4, LEAD_OUT=3 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,4,9,3
        EURO_PRN_24x9_Draft             ; RAM data for character (3*9 bytes)
        endm


EuroDraft17     macro euro_sym
        ;       Definition of the Eurocurrency symbol for Draft 17 cpi (Pica+Condensed):
        ;
        ;       12345678901234          LEAD_IN+BOX_SIZE+LEAD_OUT=14 (!)
        ;          123456789            BOX_SIZE=9 here (9 max.)
        ;       123         12          LEAD_IN=3, LEAD_OUT=2 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,3,9,2
        EURO_PRN_24x9_Draft             ; RAM data for character (3*9 bytes)
        endm


EuroDraft20     macro euro_sym
        ;       Definition of the Eurocurrency symbol for Draft 20 cpi (Elite+Condensed):
        ;
        ;       123456789012            LEAD_IN+BOX_SIZE+LEAD_OUT=12 (!)
        ;         123456789             BOX_SIZE=9 here (9 max.)
        ;       12         1            LEAD_IN=2, LEAD_OUT=1 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,2,9,1
        EURO_PRN_24x9_Draft             ; RAM data for character (3*9 bytes)
        endm


EuroLQ10        macro euro_sym
        ;       Definition of the Eurocurrency symbol for LQ 10 cpi (Pica):
        ;
        ;       123456789012345678901234567890123456 LEAD_IN+BOX_SIZE+LEAD_OUT=36 (!)
        ;           1234567890123456789012345678     BOX_SIZE=28 here (29 max.)
        ;       1234                            1234 LEAD_IN=4, LEAD_OUT=4 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,4,28,4
        EURO_PRN_24x28_LQ               ; RAM data for character (3*28 bytes)
        endm


EuroLQ12        macro euro_sym
        ;       Definition of the Eurocurrency symbol for LQ 12 cpi (Elite):
        ;
        ;       123456789012345678901234567890 LEAD_IN+BOX_SIZE+LEAD_OUT=30 (!)
        ;           1234567890123456789012     BOX_SIZE=22 here (23 max.)
        ;       1234                      1234 LEAD_IN=4, LEAD_OUT=4 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,4,22,4;
        EURO_PRN_24x22_LQ               ; RAM data for character (3*22 bytes)
        endm


EuroLQ15        macro euro_sym
        ;       Definition of the Eurocurrency symbol for LQ 15 cpi (Micro):
        ;
        ;       123456789012345678901234 LEAD_IN+BOX_SIZE+LEAD_OUT=24 (!)
        ;        1234567890123456789012  BOX_SIZE=22 here
        ;       1                      1 LEAD_IN=1, LEAD_OUT=1 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,1,22,1;
        EURO_PRN_24x22_LQ               ; RAM data for character (3*22 bytes)
        endm


EuroLQ17        macro euro_sym
        ;       Definition of the Eurocurrency symbol for LQ 17 cpi (Pica+Condensed):
        ;
        ;       123456789012345678901234567890123456 LEAD_IN+BOX_SIZE+LEAD_OUT=36 (!)
        ;           1234567890123456789012345678     BOX_SIZE=28 here (29 max.)
        ;       1234                            1234 LEAD_IN=4, LEAD_OUT=4 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,4,28,4
        EURO_PRN_24x28_LQ               ; RAM data for character (3*28 bytes)
        endm


EuroLQ20        macro euro_sym
        ;       Definition of the Eurocurrency symbol for LQ 20 cpi (Elite+Condensed):
        ;
        ;       123456789012345678901234567890 LEAD_IN+BOX_SIZE+LEAD_OUT=30 (!)
        ;           1234567890123456789012     BOX_SIZE=22 here (23 max.)
        ;       1234                      1234 LEAD_IN=4, LEAD_OUT=4 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,4,22,4;
        EURO_PRN_24x22_LQ               ; RAM data for character (3*22 bytes)
        endm


SelCPI  macro   quality, cpi
        db      ESC_,'%',0              ; select internal char set
IF quality EQ QUAL_DRAFT
        db      ESC_,'p',0              ; Proportional off
        db      ESC_,'x',0              ; select Draft
ELSEIF quality EQ QUAL_LQ
        db      ESC_,'x',1              ; select LQ
        ;db     ESC_,'p',0              ; Proportional off
ELSEIF ; QUAL_ANY
        ;db     ESC_,'p',0              ; Proportional off
ENDIF
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off
IF cpi EQ CPI_10
        db      DC2                     ; condensed script off
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'P'                ; select 10 cpi (Pica)
ELSEIF cpi EQ CPI_12
        db      DC2                     ; condensed script off
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'M'                ; select 12 cpi (Elite)
IF quality EQ QUAL_DRAFT
        db      FS_,'S',0               ; select DRAFT 12 (normal speed)
ENDIF
ELSEIF cpi EQ CPI_12HS
        db      DC2                     ; condensed script off
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'M'                ; select 12 cpi (Elite)
IF quality EQ QUAL_DRAFT
        db      FS_,'S',1               ; select HS 12
ENDIF
ELSEIF cpi EQ CPI_15
        db      DC2                     ; condensed script off
                                        ; NB. 15 cpi condensed results in the
                                        ; same resolution as 12 cpi condensed,
                                        ; that is 20 cpi. However, there's some
                                        ; fuzz with the spacing of RAM chars,
                                        ; hence we force condensed scripting to
                                        ; be off.
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'g'                ; select 15 cpi (Micro)
ELSEIF cpi EQ CPI_17
        db      ESC_,'P'                ; select 10 cpi (Pica)
        db      SI_                     ; condensed script on -> 17 cpi
        ;db     ESC_,'!',4              ; select 10 cpi and condensed
ELSEIF cpi EQ CPI_20
        db      ESC_,'M'                ; select 12 cpi (Elite)
IF quality EQ QUAL_DRAFT
        ;db     FS_,'S',0               ; select DRAFT 12 (normal speed)
ENDIF
        db      SI_                     ; condensed script on -> 20 cpi
        ;db     ESC_,'!',5              ; select 12 cpi and condensed
ENDIF
        endm


SetupEuro       macro mode, selector, quality, cpi, euro_sym
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. The previous is probably not
                                        ; supported by P5XL, P9XL, P6/P7/
                                        ; CP6/CP7, P2200, P2plus, P20/P30,
                                        ; P22Q/P32Q.
        SelCP   mode,selector           ; init sequence (again)
        SelCPI  quality,cpi             ;
        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1
IF quality EQ QUAL_DRAFT
IF cpi EQ CPI_10
        EuroDraft10 euro_sym            ; Euro symbol in Draft 10 cpi (Pica)
ELSEIF cpi EQ CPI_12
        EuroDraft12 euro_sym            ; Euro symbol in Draft 12 cpi (Elite)
ELSEIF cpi EQ CPI_12HS
        EuroDraft12HS euro_sym          ; Euro symbol in Draft HS 12 cpi (Elite)
ELSEIF cpi EQ CPI_15
        EuroDraft15 euro_sym            ; Euro symbol in Draft 15 cpi (Micro)
ELSEIF cpi EQ CPI_17
        EuroDraft17 euro_sym            ; Euro symbol in Draft 17 cpi (Pica+Condensed)
ELSEIF cpi EQ CPI_20
        EuroDraft20 euro_sym            ; Euro symbol in Draft 20 cpi (Elite+Condensed)
ELSE ; CPI_ANY         ; DEBUG: This shouldn't happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_DRAFT+CPI_ANY"
        ;EuroDraft10 euro_sym           ; Euro symbol in Draft
ENDIF ; cpi
ELSEIF quality EQ QUAL_LQ
IF cpi EQ CPI_10
        EuroLQ10 euro_sym               ; Euro symbol in LQ 10 cpi (Pica)
ELSEIF cpi EQ CPI_12
        EuroLQ12 euro_sym               ; Euro symbol in LQ 12 cpi (Elite)
ELSEIF cpi EQ CPI_12HS ; DEBUG: This must not happen!!!
        .ERR "SetupEuro: Invalid combination of parameters: QUAL_LQ+CPI_12HS"
        ;EuroLQ12 euro_sym              ; Euro symbol in LQ
ELSEIF cpi EQ CPI_15
        EuroLQ15 euro_sym               ; Euro symbol in LQ 15 cpi (Micro)
ELSEIF cpi EQ CPI_17
        EuroLQ17 euro_sym               ; Euro symbol in LQ 17 cpi (Pica+Condensed)
ELSEIF cpi EQ CPI_20
        EuroLQ20 euro_sym               ; Euro symbol in LQ 20 cpi (Elite+Condensed)
ELSE ; CPI_ANY         ; DEBUG: This should not happen!!!
       .ERR "SetupEuro: Unusual combination of parameters: QUAL_LQ+CPI_ANY"
        ;EuroLQ10 euro_sym              ; Euro symbol in LQ
ENDIF ; cpi
ELSE ; QUAL_ANY
IF cpi EQ CPI_10       ; DEBUG: This should not happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_ANY+CPI_10"
        ;EuroDraft10 euro_sym           ; Euro symbol in Universal (as Draft)
ELSEIF cpi EQ CPI_12   ; DEBUG: This should not happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_ANY+CPI_12"
        ;EuroDraft12 euro_sym           ; Euro symbol in Universal (as Draft)
ELSEIF cpi EQ CPI_12HS ; DEBUG: This should not happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_ANY+CPI_12HS"
        ;EuroDraft12HS euro_sym         ; Euro symbol in Universal (as Draft)
ELSEIF cpi EQ CPI_15   ; DEBUG: This should not happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_ANY+CPI_15"
        ;EuroDraft15 euro_sym           ; Euro symbol in Universal (as Draft)
ELSEIF cpi EQ CPI_17   ; DEBUG: This should not happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_ANY+CPI_17"
        ;EuroDraft17 euro_sym           ; Euro symbol in Universal (as Draft)
ELSEIF cpi EQ CPI_20   ; DEBUG: This should not happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_ANY+CPI_20"
        ;EuroDraft20 euro_sym           ; Euro symbol in Universal (as Draft)
ELSE ; CPI_ANY
        EuroDraft10 euro_sym            ; Euro symbol in Universal (as Draft)
ENDIF ; cpi
ENDIF ; quality
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO
        endm


; #############################################################################

Code Segment
        ASSUME CS:Code, DS:Code
        org     0

NECPINW_CPI:

; #############################################################################

FontFileHeader:
        db      0FFh
        db      "FONT",SPACE,SPACE,SPACE
        db      8 DUP (NUL)
        dw      1                       ; count of pointers in header
        db      1                       ; type of info pointer
                                        ;
;;      dd      offset FontInfoHeader   ; pointer to start of list
        dw      offset FontInfoHeader   ;
        dw      0                       ; (offset always zero)

; #############################################################################

FontInfoHeader:
        dw      CP_COUNT                ; count of Code Pages in file

; #############################################################################

        ENTRY_COUNTER = 0

;CPEntryHeader:
        CPEntry prn367, prn437,  367, data367, NOTLAST ; ANSI X3.4 ASCII, ISO-646-US
        CPEntry prn437, prn667,  437, data437, NOTLAST ; CP 437
        CPEntry prn667, prn737,CP667, data667, NOTLAST ; PTS-DOS CP 667
        CPEntry prn737, prn850,  737, data737, NOTLAST ;
        CPEntry prn850, prn852,  850, data850, NOTLAST ; CP 850
        CPEntry prn852, prn853,  852, data852, NOTLAST ; CP 852
        CPEntry prn853, prn855,  853, data853, NOTLAST ;
        CPEntry prn855, prn857,  855, data855, NOTLAST ; CP 855
        CPEntry prn857, prn860,  857, data857, NOTLAST ;
        CPEntry prn860, prn863,  860, data860, NOTLAST ; CP 860
        CPEntry prn863, prn865,  863, data863, NOTLAST ; CP 863
        CPEntry prn865, prn866,  865, data865, NOTLAST ; CP 865
        CPEntry prn866, prn867,  866, data866, NOTLAST ; CP 866
        CPEntry prn867, prn991,CP867, data867, NOTLAST ;
        CPEntry prn991,prn8501,CP991, data991, NOTLAST ; PLC CP 991
IF 0
        ; NB. These entries are not currently enabled, because I'm not
        ;     sure if these would be actually the correct numbers. I would
        ;     need to have access to the IBM CDRA level 2 CD-ROM to verify
        ;     this. For now use "user definable" numbers in the range
        ;     FF00h..FFFEh instead.
        CPEntry prn1009,prn1010,1009,data1009, NOTLAST ; ISO-7 IRV (prior 1992)
        CPEntry prn1010,prn1011,1010,data1010, NOTLAST ; ISO-7 France
        CPEntry prn1011,prn1012,1011,data1011, NOTLAST ; ISO-7 Germany
        CPEntry prn1012,prn1013,1012,data1012, NOTLAST ; ISO-7 Italy
        CPEntry prn1013,prn1014,1013,data1013, NOTLAST ; ISO-7 United Kingdom
        CPEntry prn1014,prn1015,1014,data1014, NOTLAST ; ISO-7 Spain
        ;CPEntry prn1015,prn1016,1015,data1015,NOTLAST ; ISO-7 Portugal
        CPEntry prn1016,prn1017,1016,data1016, NOTLAST ; ISO-7 Norway
        CPEntry prn1017,prn1018,1017,data1017, NOTLAST ; ISO-7 Denmark
        CPEntry prn1018,prn1019,1018,data1018, NOTLAST ; ISO-7 Finland, Sweden
        CPEntry prn1019,prn1020,1019,data1019, NOTLAST ; ISO-7 Belgium, Netherlands
        ;CPEntry prn1020,prn1021,1020,data1020,NOTLAST ; ISO-7 French Canadia variant
        ;CPEntry prn1021,prn1023,1021,data1021,NOTLAST ; ISO-7 Switzerland variant
        CPEntry prn1023,prn1101,1023,data1023, NOTLAST ; ISO-7 Spain variant
        ;CPEntry prn1101,prn1102,1101,data1101,NOTLAST ; ISO-7 British NRC Set
        ;CPEntry prn1102,prn1103,1102,data1102,NOTLAST ; ISO-7 Dutch NRC Set
        ;CPEntry prn1103,prn1104,1103,data1103,NOTLAST ; ISO-7 Finnish NRC Set
        ;CPEntry prn1104,prn1105,1104,data1104,NOTLAST ; ISO-7 French NRC Set
        ;CPEntry prn1105,prn1106,1105,data1105,NOTLAST ; ISO-7 Norwegian/Danish NRC Set
        ;CPEntry prn1106,prn1107,1106,data1106,NOTLAST ; ISO-7 Swedish NRC Set
        ;CPEntry prn1107,prn8501,1107,data1107,NOTLAST ; ISO-7 Norwegian/Danish NRC Set (Alternate)
ENDIF
        ; NB. 8501 is just my proposal for the CP 850 variant with Eurocurrency.
        CPEntry prn8501,prn58194,CP8501,data8501,NOTLAST

        ; IBM CDRA level 2 user definable range E000h..EFFFh for CCSIDs:
        ;
        ; NB. IBM CDRA compatible definition for a private variant of CP 850:
        ;     CP 850 = 0352h => E352h = 58194 to be used.
        ;     We use it as an alias to our 8501 Code Page here...

        CPEntry prn58194,prn58805,58194,data58194,NOTLAST ; Euro at D5h

        ; NB. IBM CDRA compatible definition for private variants of
        ;     CP 437, 667, 850, 863, 865, 991:
        ;     CP 437 = 01B5h => E1B5h+0400h = E5B5h = 58805
        ;     CP 850 = 0352h => E352h+0400h = E69Bh = 59035 etc.
        ;     We add +0400h for our FreeDOS EUROTSR compatible definitions
        ;     since we better leave the range E000h..E3FFh alone for future
        ;     "official" Code Page variants 0..999 (3E7h).

        CPEntry prn58805,prn59035,58805,data58805,NOTLAST ; 437 with Euro at 9Fh
        CPEntry prn59035,prn59218,59035,data59035,NOTLAST ; 667 with Euro at 9Fh
        CPEntry prn59218,prn59231,59218,data59218,NOTLAST ; 850 with Euro at 9Fh
        CPEntry prn59231,prn59233,59231,data59231,NOTLAST ; 863 with Euro at 9Fh
        CPEntry prn59233,prn59359,59233,data59233,NOTLAST ; 865 with Euro at 9Fh
        CPEntry prn59359,prn65280,59359,data59359,NOTLAST ; 991 with Euro at 9Fh

        ; IBM CDRA level 2 user definable range FF00h..FFFEh for CPGIDs:
        ;
        ; NB. The user definable range of CPGIDs allows to define private
        ;     "Code Pages" to directly address all selection IDs 0..25
        ;     available on the NEC Pinwriters under a specific number
        ;     regardless of any offical Code Page assignments in existance.
        ;     Also added are values to select any of the download or cardridge
        ;     fonts as well as internal type face fonts.
        ;     Please note, that these numbers are specific to NECPINW.CPI
        ;     and the results depend on the model and configuration of the
        ;     NEC Pinwriter controlled by PRINTER.SYS + NECPINW.CPI.
        ;     You must *not* assume that the use of these IDs will produce
        ;     similar char sets on other devices or with other software,
        ;     it may even change with future issues of NECPINW.CPI.

        CPEntry prn65280,prn65281,65280,data65280,NOTLAST ; 7-bit USA (0)
        CPEntry prn65281,prn65282,65281,data65281,NOTLAST ; 7-bit France (1)
        CPEntry prn65282,prn65283,65282,data65282,NOTLAST ; 7-bit Germany (2)
        CPEntry prn65283,prn65284,65283,data65283,NOTLAST ; 7-bit UK (3)
        CPEntry prn65284,prn65285,65284,data65284,NOTLAST ; 7-bit Denmark I (4)
        CPEntry prn65285,prn65286,65285,data65285,NOTLAST ; 7-bit Sweden (5)
        CPEntry prn65286,prn65287,65286,data65286,NOTLAST ; 7-bit Italy (6)
        CPEntry prn65287,prn65288,65287,data65287,NOTLAST ; 7-bit Spain I (7)
        CPEntry prn65288,prn65289,65288,data65288,NOTLAST ; 7-bit Japan (8)
        CPEntry prn65289,prn65290,65289,data65289,NOTLAST ; 7-bit Norway I (9)
        CPEntry prn65290,prn65291,65290,data65290,NOTLAST ; 7-bit Denmark II (10)
        CPEntry prn65291,prn65292,65291,data65291,NOTLAST ; 7-bit Netherlands (11)
        CPEntry prn65292,prn65293,65292,data65292,NOTLAST ; 7-bit Turkey (12)
        CPEntry prn65293,prn65294,65293,data65293,NOTLAST ; 7-bit Spain II (13)
IF DEBUG EQ 1
        CPEntry prn65294,prn65295,65294,data65294,NOTLAST ; 7-bit Latin America (14)
        CPEntry prn65295,prn65296,65295,data65295,NOTLAST ; undefined??? (15)
ELSE
        CPEntry prn65294,prn65296,65294,data65294,NOTLAST ; 7-bit Latin America (14)
ENDIF
        CPEntry prn65296,prn65297,65296,data65296,NOTLAST ; Multilingual 850 (16)
        CPEntry prn65297,prn65298,65297,data65297,NOTLAST ; Portugual 860 (17)
        CPEntry prn65298,prn65299,65298,data65298,NOTLAST ; French Canada 863 (18)
        CPEntry prn65299,prn65300,65299,data65299,NOTLAST ; Norway II 865 (19)
                                                          ;
        CPEntry prn65300,prn65301,65300,data65300,NOTLAST ; EPROM (20)
        CPEntry prn65301,prn65302,65301,data65301,NOTLAST ; EPROM (21)
        CPEntry prn65302,prn65303,65302,data65302,NOTLAST ; EPROM (22)
        CPEntry prn65303,prn65304,65303,data65303,NOTLAST ; EPROM (23)
        CPEntry prn65304,prn65305,65304,data65304,NOTLAST ; EPROM (24)
     
IF DEBUG EQ 1
        CPEntry prn65305,prn65306,65305,data65305,NOTLAST ; EPROM (25)
        CPEntry prn65306,prn65344,65306,data65306,NOTLAST ; EPROM (26)
        CPEntry prn65344,prn65392,65344,data65344,NOTLAST ; EPROM (64)
ELSE
        CPEntry prn65305,prn65392,65305,data65305,NOTLAST ; EPROM (25)
ENDIF
        CPEntry prn65392,prn65393,65392,data65392,NOTLAST ; Euro universal
        CPEntry prn65393,prn65394,65393,data65393,NOTLAST ; Euro Draft 10 cpi
        CPEntry prn65394,prn65395,65394,data65394,NOTLAST ; Euro Draft 12 cpi
        CPEntry prn65395,prn65396,65395,data65395,NOTLAST ; Euro Draft HS 12 cpi
        CPEntry prn65396,prn65397,65396,data65396,NOTLAST ; Euro Draft 15
        CPEntry prn65397,prn65398,65397,data65397,NOTLAST ; Euro Draft 17
        CPEntry prn65398,prn65401,65398,data65398,NOTLAST ; Euro Draft 20
        CPEntry prn65401,prn65402,65401,data65401,NOTLAST ; Euro LQ 10 cpi
        CPEntry prn65402,prn65403,65402,data65402,NOTLAST ; Euro LQ 12 cpi
        CPEntry prn65403,prn65404,65403,data65403,NOTLAST ; Euro LQ 15 cpi
        CPEntry prn65404,prn65405,65404,data65404,NOTLAST ; Euro LQ 17
        CPEntry prn65405,prn65408,65405,data65405,NOTLAST ; Euro LQ 20

        CPEntry prn65408,prn65409,65408,data65408,NOTLAST ; Download (default)
        CPEntry prn65409,prn65410,65409,data65409,NOTLAST ; Download 1
        CPEntry prn65410,prn65424,65410,data65410,NOTLAST ; Download 2
                                                          ;
        CPEntry prn65424,prn65425,65424,data65424,NOTLAST ; internal fonts (default)
        CPEntry prn65425,prn65426,65425,data65425,NOTLAST ; external font 1
        CPEntry prn65426,prn65427,65426,data65426,NOTLAST ; external font 2
        CPEntry prn65427,prn65428,65427,data65427,NOTLAST ; external font 3
        CPEntry prn65428,prn65440,65428,data65428,NOTLAST ; external font 4
                                                          ;
        CPEntry prn65440,prn65446,65440,data65440,NOTLAST ; internal font 0
        CPEntry prn65446,prn65452,65446,data65446,NOTLAST ; internal font 6
        CPEntry prn65452,prn65455,65452,data65452,NOTLAST ; internal font 12
        CPEntry prn65455,prn65456,65455,data65455,NOTLAST ; internal font 15
        CPEntry prn65456,prn65458,65456,data65456,NOTLAST ; internal font 16
        CPEntry prn65458,prn65459,65458,data65458,NOTLAST ; internal font 18
        CPEntry prn65459,prn65474,65459,data65459,NOTLAST ; internal font 19
        CPEntry prn65474,prn65490,65474,data65474,NOTLAST ; internal font 34
        CPEntry prn65490,prn65491,65490,data65490,NOTLAST ; internal font 50
        CPEntry prn65491,prn65492,65491,data65491,NOTLAST ; internal font 51
        CPEntry prn65492,prn65493,65492,data65492,NOTLAST ; internal font 52
        CPEntry prn65493,FontDataHeader,65493,data65493,LAST; internal font 53

        CP_COUNT = ENTRY_COUNTER

; #############################################################################

FontDataHeader:

        CPData  data437,data58805,GRAPHICS,ID_0,seq437

        ; IBM CDRA level 2 user definable range E000h..EFFFh for CCSIDs:

                ; (for CP 58194 see CP 65392..CP65405 below)

        CPData  data58805,data59035,GRAPHICS,ID_16,seq58805 ; CP 437 variant
        SetupEuro GRAPHICS,ID_0, QUAL_FD,CPI_FD,EURO_CHR_FD ; with Euro at 9Fh

data59359:                                     ; (with EPROM #8 "Polish" only)
        CPData  data59035,data59218,GRAPHICS,ID_16,seq59035 ; CP 667/991 variant
        SetupEuro GRAPHICS,ID_21,QUAL_FD,CPI_FD,EURO_CHR_FD ; with Euro at 9Fh

        CPData  data59218,data59231,GRAPHICS,ID_16,seq59218 ; CP 850 variant
        SetupEuro GRAPHICS,ID_16,QUAL_FD,CPI_FD,EURO_CHR_FD ; with Euro at 9Fh

        CPData  data59231,data59233,GRAPHICS,ID_16,seq59231 ; CP 863 variant
        SetupEuro GRAPHICS,ID_18,QUAL_FD,CPI_FD,EURO_CHR_FD ; with Euro at 9Fh

        CPData  data59233,data65280,GRAPHICS,ID_16,seq59233 ; CP 865 variant
        SetupEuro GRAPHICS,ID_19,QUAL_FD,CPI_FD,EURO_CHR_FD ; with Euro at 9Fh

        ; IBM CDRA level 2 user definable range FF00h..FFFEh for CPGIDs:

data367:        ; ISO-646 7-bit ASCII (US)
;data1009:
        CPData  data65280,data65281,ITALICS,ID_0,seq65280  ; 7-bit USA (0)
;data1010:
        CPData  data65281,data65282,ITALICS,ID_1,seq65281  ; 7-bit France (1)
;data1011:
        CPData  data65282,data65283,ITALICS,ID_2,seq65282  ; 7-bit Germany (2)
;data1013:
        CPData  data65283,data65284,ITALICS,ID_3,seq65283  ; 7-bit UK (3)
;data1017:
        CPData  data65284,data65285,ITALICS,ID_4,seq65284  ; 7-bit Denmark I (4)
;data1018:
        CPData  data65285,data65286,ITALICS,ID_5,seq65285  ; 7-bit Sweden (5)
;data1012:
        CPData  data65286,data65287,ITALICS,ID_6,seq65286  ; 7-bit Italy (6)
;data1014:
        CPData  data65287,data65288,ITALICS,ID_7,seq65287  ; 7-bit Spain I (7)
        CPData  data65288,data65289,ITALICS,ID_8,seq65288  ; 7-bit Japan (8)
;data1016:
        CPData  data65289,data65290,ITALICS,ID_9,seq65289  ; 7-bit Norway I (9)
        CPData  data65290,data65291,ITALICS,ID_10,seq65290 ; 7-bit Denmark II (10)
;data1019:
        CPData  data65291,data65292,ITALICS,ID_11,seq65291 ; 7-bit Netherlands (11)
        CPData  data65292,data65293,ITALICS,ID_12,seq65292 ; 7-bit Turkey (12)
;data1023:
        CPData  data65293,data65294,ITALICS,ID_13,seq65293 ; 7-bit Spain II (13)

IF DEBUG EQ 1
        CPData  data65294,data65295,ITALICS,ID_14,seq65294  ; 7-bit Latin America (14)
        CPData  data65295,data65296,GRAPHICS,ID_15,seq65295 ; not used??? (15)
ELSE
        CPData  data65294,data65296,ITALICS,ID_14,seq65294  ; 7-bit Latin America (14)
ENDIF

IF NOT EURO_850 EQ 1
data850:        ; CP 850
ENDIF
        CPData  data65296,data65297,GRAPHICS,ID_16,seq65296 ; Multilingual (16)

data860:        ; CP 860
        CPData  data65297,data65298,GRAPHICS,ID_17,seq65297 ; Portugual (17)

data863:        ; CP 863
        CPData  data65298,data65299,GRAPHICS,ID_18,seq65298 ; French Canada (18)

data865:        ; CP 865
        CPData  data65299,data65300,GRAPHICS,ID_19,seq65299 ; Norway II (19)

data737:        ; (Similar to CP 737 with EPROM #3 "Greek" only)
data852:        ; CP 852 with EPROMs #2 "East Europe", #5/#6 "Code Tables", #7 "Hungaria", #8 "Polish"
data853:        ; (Similar to CP 853 with EPROM #4 "Turkey"/"CT Turkey" only)
data857:        ; (Similar to CP 857 with EPROM #4 "Turkey"/"CT Turkey" only)
        CPData  data65300,data65301,GRAPHICS,ID_20,seq65300 ; EPROM (20)

data667:        ; CP 667 "Mazovia" with EPROM #8 "Polish" only
IF NOT EPROM_NO EQ 1
data866:        ; CP 866 with EPROMs #5/#6 "Code Tables" only
ENDIF
data991:        ; CP 991 "Mazovia" with EPROM #8 "Polish" only
        CPData  data65301,data65302,GRAPHICS,ID_21,seq65301 ; EPROM (21)

IF EPROM_NO EQ 1
data866:        ; CP 866 with EPROM #1 "Russian" only
ELSE
data855:        ; CP 855 with EPROMs #5/#6 "Code Tables" only
ENDIF
        CPData  data65302,data65303,GRAPHICS,ID_22,seq65302 ; EPROM (22)

data867:        ; (Probably CP 867 "Czech/Kamenicky" with EPROM #2 "East Europe" only)
        CPData  data65303,data65304,GRAPHICS,ID_23,seq65303 ; EPROM (23)

IF EPROM_NO EQ 1
data855:        ; CP 855 with EPROM #1 "Russian" only
ENDIF
        CPData  data65304,data65305,GRAPHICS,ID_24,seq65304 ; EPROM (24)

IF DEBUG EQ 1
        CPData  data65305,data65306,GRAPHICS,ID_25,seq65305 ; EPROM (25)
        CPData  data65306,data65344,GRAPHICS,ID_26,seq65306 ; not used??? (26)
        CPData  data65344,data65392,GRAPHICS,ID_64,seq65344 ; not used??? (64)
ELSE
        CPData  data65305,data65392,GRAPHICS,ID_25,seq65305 ; EPROM (25)
ENDIF

IF EURO_STYLE EQ 0
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65392,data65393,GRAPHICS,ID_16,seq65392 ; Euro at D5h Universal
        SetupEuro GRAPHICS,ID_16,QUAL_ANY,CPI_ANY,EURO_CHR_850 ; (same as Draft)

IF EURO_STYLE EQ 1
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65393,data65394,GRAPHICS,ID_16,seq65393 ; Euro at D5h in Draft
        SetupEuro GRAPHICS,ID_16,QUAL_DRAFT,CPI_10,EURO_CHR_850 ; 10 cpi (Pica)

IF EURO_STYLE EQ 2
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65394,data65395,GRAPHICS,ID_16,seq65394 ; Euro at D5h in Draft
        SetupEuro GRAPHICS,ID_16,QUAL_DRAFT,CPI_12,EURO_CHR_850 ; 12 cpi (Elite)

IF EURO_STYLE EQ 3
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65395,data65396,GRAPHICS,ID_16,seq65395 ; Euro at D5h in Draft HS
        SetupEuro GRAPHICS,ID_16,QUAL_DRAFT,CPI_12HS,EURO_CHR_850 ; 12 cpi (Elite)

IF EURO_STYLE EQ 4
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65396,data65397,GRAPHICS,ID_16,seq65396 ; Euro at D5h in Draft
        SetupEuro GRAPHICS,ID_16,QUAL_DRAFT,CPI_15,EURO_CHR_850 ; 15 cpi (Micro)

IF EURO_STYLE EQ 5
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65397,data65398,GRAPHICS,ID_16,seq65397 ; Euro at D5h in Draft
        SetupEuro GRAPHICS,ID_16,QUAL_DRAFT,CPI_17,EURO_CHR_850 ; 17 cpi (Pica+Condensed)

IF EURO_STYLE EQ 6
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65398,data65401,GRAPHICS,ID_16,seq65398 ; Euro at D5h in Draft
        SetupEuro GRAPHICS,ID_16,QUAL_DRAFT,CPI_20,EURO_CHR_850 ; 20 cpi (Elite+Condensed)

IF EURO_STYLE EQ 9
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65401,data65402,GRAPHICS,ID_16,seq65401 ; Euro at D5h in LQ
        SetupEuro GRAPHICS,ID_16,QUAL_LQ,CPI_10,EURO_CHR_850; 10 cpi (Pica)

IF EURO_STYLE EQ 10
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65402,data65403,GRAPHICS,ID_16,seq65402 ; Euro at D5h in LQ
        SetupEuro GRAPHICS,ID_16,QUAL_LQ,CPI_12,EURO_CHR_850; 12 cpi (Elite)

IF EURO_STYLE EQ 11
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65403,data65404,GRAPHICS,ID_16,seq65403 ; Euro at D5h in LQ
        SetupEuro GRAPHICS,ID_16,QUAL_LQ,CPI_15,EURO_CHR_850; 15 cpi (Micro)

IF EURO_STYLE EQ 12
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65404,data65405,GRAPHICS,ID_16,seq65404 ; Euro at D5h in LQ
        SetupEuro GRAPHICS,ID_16,QUAL_LQ,CPI_17,EURO_CHR_850; 17 cpi (Pica+Condensed)

IF EURO_STYLE EQ 13
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65405,data65408,GRAPHICS,ID_16,seq65405 ; Euro at D5h in LQ
        SetupEuro GRAPHICS,ID_16,QUAL_LQ,CPI_20,EURO_CHR_850; 20 cpi (Elite+Condensed)

        CPData  data65408,data65409,GRAPHICS,ID_0,seq65408  ; Download
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'%',1              ; select (last) download char set

        CPData  data65409,data65410,GRAPHICS,ID_0,seq65409  ; Download 1
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'%',1              ; select download char set
        db      FS_,'X',0               ; select download char set 1
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7, P2200,
                                        ; P2plus, P20/P30, P22Q/P32Q.

        CPData  data65410,data65424,GRAPHICS,ID_0,seq65410  ; Download 2
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'%',1              ; select download char set
        ;db     FS_,'W',0               ; select 2*128 instead of 1*256
                                        ; NB. I disabled this because I
                                        ; haven't tested yet, if this would
                                        ; delete the DL buffer, if we're
                                        ; already in 2*128 mode. If not,
                                        ; we should put it back in...
        db      FS_,'X',1               ; select download char set 2
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7, P2200,
                                        ; P2plus, P20/P30, P22Q/P32Q.

        CPData  data65424,data65425,GRAPHICS,ID_0,seq65424  ; Internal fonts
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.

        CPData  data65425,data65426,GRAPHICS,ID_0,seq65425  ; Cardridge font 1
        db      FS_,'C',1               ; select external font 1
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.

        CPData  data65426,data65427,GRAPHICS,ID_0,seq65426  ; Cardridge font 2
        db      FS_,'C',2               ; select external font 2
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.

        CPData  data65427,data65428,GRAPHICS,ID_0,seq65427  ; Cardridge font 3
        db      FS_,'C',3               ; select external font 3
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.

        CPData  data65428,data65440,GRAPHICS,ID_0,seq65428  ; Cardridge font 4
        db      FS_,'C',4               ; select external font 4
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.

        CPData  data65440,data65446,GRAPHICS,ID_0,seq65440 ; Internal font 0
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_COURIER_10  ; select "Courier 10"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65446,data65452,GRAPHICS,ID_0,seq65446 ; Internal font 6
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_SUPERFOCUS  ; select "Super Focus"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65452,data65455,GRAPHICS,ID_0,seq65452 ; Internal font 12
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_OCR_B       ; select "OCR-B"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65455,data65456,GRAPHICS,ID_0,seq65455 ; Internal font 15
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_ITCSOUVENIR_10; select "ITC Souvenir 10"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65456,data65458,GRAPHICS,ID_0,seq65456 ; Internal font 16
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_HELVETTE_10PT; select "Helvette 10 PT"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.
        ;db     ESC_,'p',1              ; Proportional on

        CPData  data65458,data65459,GRAPHICS,ID_0,seq65458 ; Internal font 18
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_TIMES_10PT  ; select "Times 10 PT"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.
        ;db     ESC_,'p',1              ; Proportional on

        CPData  data65459,data65474,GRAPHICS,ID_0,seq65459 ; Internal font 19
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_NEWPRESTIGEELITE_12WP; select "New Prestige Elite 12 WP"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.
        ;db     ESC_,'p',1              ; Proportional on

        CPData  data65474,data65490,GRAPHICS,ID_0,seq65474 ; Internal font 34
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_BOLD_PS     ; select "Bold PS"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65490,data65491,GRAPHICS,ID_0,seq65490 ; Internal font 50
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_FASTFOCUS_10; select "Fast Focus 10"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65491,data65492,GRAPHICS,ID_0,seq65491 ; Internal font 51
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_FASTFOCUS_12; select "Fast Focus 12"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65492,data65493,GRAPHICS,ID_0,seq65492 ; Internal font 52
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_QUICKGOTHIC_10; select "Quick Gothic 10"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65493,Footer,GRAPHICS,ID_0,seq65493 ; Internal font 53
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_QUICKGOTHIC_12; select "Quick Gothic 12"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

; #############################################################################

Footer:

; NB. The VeRsIoN=, CoPyRiGhT=, NaMe SeRvIcE=, and VeRsIoN#= tags are
; compatible with the Novell / Caldera / Lineo VERSION utility. The LaNgUaGe=,
; SeRiAlNuMbEr=, LiCeNsE=, and AuThOrS= tags are my own proposals, but at
; least the first two are already used in some of the DR-DOS files.
; Do not change the standardized format of these strings.

        db      CR,LF
        db      "------------------------------------------------------------------------------",CR,LF
        db      FILE_NAME, " VeRsIoN=", VERSION_MSG, " (", DATE_MSG, ")",NUL,CR,LF
        ;db     "VeRsIoN#=",followed by 3 DWORDs for mainver,subver, and revision
        db      "CoPyRiGhT=(C) 1996-2000 by Matthias Paul, Ubierstrasse 28, D-50321 Bruehl",NUL,CR,LF
IF CPI_STYLE EQ 1
        db      "NaMe SeRvIcE=",FILE_NAME,' DOS Code Page Information file ("EPS") for',CR,LF
ELSEIF CPI_STYLE EQ 2
        db      "NaMe SeRvIcE=",FILE_NAME,' DOS Code Page Information file ("4201") for',CR,LF
ELSEIF CPI_STYLE EQ 3
        db      "NaMe SeRvIcE=",FILE_NAME,' DOS Code Page Information file ("NECPINW") for',CR,LF
ELSE
        db      "NaMe SeRvIcE=",FILE_NAME,' DR-DOS Code Page Information file ("1050") for',CR,LF
ENDIF
        db      "NEC Pinwriter series",NUL,CR,LF
        db      "LaNgUaGe=International (1)",NUL,CR,LF
        db      "LiCeNsE=GNU General Public License 2 (or at your option any later version):",CR,LF
        db      "This is free software that comes with ABSOLUTELY NO WARRANTY. You are welcome",CR,LF
        db      "to redistribute it under certain conditions. Refer to the GNU GPL license file",CR,LF
        db      "you should have received along with ",FILE_NAME," (or see http://www.gnu.org).",NUL,CR,LF
        ;db     "SeRiAlNuMbEr=XXXX-0000-654321",NUL,CR,LF
        ;db     "AuThOrS=Matthias Paul, ...",NUL,CR,LF
        db      "------------------------------------------------------------------------------",CR,LF
        db      "EMail: <Matthias.Paul@post.rwth-aachen.de>",CR,LF
        db      "Web: http://www.rhrz.uni-bonn.de/~uzs180/mpdokeng.html",CR,LF
        db      "------------------------------------------------------------------------------",CR,LF
        db      FILE_NAME, " provides Code Page switching support for the IBM Code Pages",CR,LF
        db      "367 (7-bit ISO-646-US, ASCII), 437 (International, Western Europe, IBM-2,",CR,LF
        db      "PC-8, World Trade Set), 850 (Multilingual, Latin I), 860 (Portuguese),",CR,LF
        db      "863 (French Canadian), and 865 (Nordic, Norway II) with the NEC Pinwriters",CR,LF
        db      "P5200/P5300 (P6plus/P7plus), P3200/P3300 (P20/P30), P6200/P6300 (P60/P70),",CR,LF
        db      "P9300 (P90), P22Q/P32Q, P7200/P7300 (P62/P72), P3800/P3900 (P42Q/P52Q),",CR,LF
        db      "P8000 (P72X), and other compatible printer models.",CR,LF
        db      "Except for the Pinwriters P5200/P5300 (P6plus/P7plus), they optionally support",CR,LF
        db      "Code Pages 667/991 (Polish, Mazovia), 852 (Slavic, Eastern Europe, Latin II),",CR,LF
        db      "855 (Cyrillic I), 866 (Russian, Cyrillic II), and 867 (Czech, Kamenicky), if",CR,LF
        db      "the appropriate font EPROM is installed. Printers configured to support a 256",CR,LF
        db      "char download font can also make use of Code Page 8501/58194 (Multilingual",CR,LF
        db      "with Eurocurrency) in LQ 10 cpi (Pica) mode. Please refer to the documentation",CR,LF
        db      "to learn about a large set of other character sets available with ",FILE_NAME,".",CR,LF
        db      "The Pinwriters P2200 and P2200XE (P2plus) do not support Code Page switching,",CR,LF
        db      "therefore they are supported for Code Pages 367 and 437 only. The Pinwriters",CR,LF
        db      "P2/P3/CP2/CP3, P5/P5XL, P9XL, and P6/P7/CP6/CP7 are not supported at all.",CR,LF
IF CPI_STYLE EQ 1
        db      'For compatibility reasons this file pretends to be an "EPS" style file for',CR,LF
        db      "Epson ESC/P printers, while it actually supports the range of NEC Pinwriter by",CR,LF
        db      "replacing the original EPS.CPI file shipping with PC DOS 6.1 and 6.3. It is",CR,LF
        db      "designed for use with PRINTER.SYS of PC DOS 6.1+. You may need to patch the",CR,LF
        db      "file for use with MS-DOS. An issue for DR DOS 6.0+ is available.",CR,LF
ELSEIF CPI_STYLE EQ 2
        db      'For compatibility reasons this file pretends to be an "4201" style file for',CR,LF
        db      "IBM Proprinter II & III Model 4201 & XL Model 4202 printers, while it actually",CR,LF
        db      "supports the NEC Pinwriter series by replacing the original 4201.CPI file",CR,LF
        db      "shipping with MS-DOS/PC DOS or DR DOS. An issue optimized for DR DOS 6.0+ is",CR,LF
        db      "also available.",CR,LF
ELSEIF CPI_STYLE EQ 3
        db      "This file is designed to be used under a future DR-DOS 7+ and/or FreeDOS.",CR,LF
        db      "It is not supported by any currently available DOS. An optimized issue for",CR,LF
        db      "DR DOS 6.0+ is also available.",CR,LF
ELSE
        db      'For compatibility reasons this printer Code Page file pretends to be a "1050"',CR,LF
        db      "style file for the Epson FX-850/FX-1050 printers, while it actually supports",CR,LF
        db      "the NEC Pinwriter series by replacing the original 1050.CPI file. It is",CR,LF
        db      'designed for use with PRINTER.SYS of DR DOS 6.0, (DR PalmDOS), "Panther" &',CR,LF
        db      '"StarTrek", Novell DOS 7, Caldera OpenDOS 7.01, DR-OpenDOS 7.02, and DR-DOS',CR,LF
        db      "7.02-7.05. You need to patch the file for use with MS-DOS or PC DOS or with",CR,LF
        db      "older issues of DR DOS.",CR,LF
ENDIF
        db      "------------------------------------------------------------------------------",CR,LF
        db      "Installation (for country 49 (Germany), Code Pages 437 and 850, here):",CR,LF
        db      CR,LF
        db      "  CONFIG.SYS:",CR,LF
IF CPI_STYLE EQ 1
        db      "    COUNTRY=49,437,...\COUNTRY.SYS",CR,LF
        db      "    DEVICE|DEVICEHIGH=...\PRINTER.SYS PRN=(EPS,999,2)",CR,LF
ELSEIF CPI_STYLE EQ 2
        db      "    COUNTRY=49,437,...\COUNTRY.SYS",CR,LF
        db      "    DEVICE|DEVICEHIGH=...\PRINTER.SYS PRN=(4201,999,2)",CR,LF
ELSEIF CPI_STYLE EQ 3
        db      "    COUNTRY=49,437,...\COUNTRY.SYS",CR,LF
        db      "    DEVICE|DEVICEHIGH|HIDEVICE=...\PRINTER.SYS PRN=(1050,999,2)",CR,LF
ELSE
        db      "    COUNTRY=49,437,C:\DRDOS\COUNTRY.SYS",CR,LF
        db      "    DEVICE|HIDEVICE|DEVICEHIGH=C:\DRDOS\PRINTER.SYS PRN=(1050,999,2)",CR,LF
ENDIF
        db      CR,LF
        db      "  AUTOEXEC.BAT:",CR,LF
IF CPI_STYLE EQ 0
        db      "    MODE PRN: CODEPAGE PREPARE=((437,850) C:\DRDOS\",FILE_NAME,")",CR,LF
        db      "    [HILOAD|LH] NLSFUNC C:\DRDOS\COUNTRY.SYS",CR,LF
ELSE
        db      "    MODE PRN: CODEPAGE PREPARE=((437,850) ...\",FILE_NAME,")",CR,LF
        db      "    [LH] NLSFUNC ...\COUNTRY.SYS",CR,LF
ENDIF
        db      "    CHCP 437",CR,LF
        db      "    REM MODE PRN: CODEPAGE SELECT=850",CR,LF
        db      CR,LF
        db      "Please refer to DOS user manuals (or my NWDOSTIP.TXT documentation - part of",CR,LF
        db      "my MPDOSTIP.ZIP tips & tricks collection) for more info on how to install",CR,LF
        db      "Code Page support. Also, look out for CPI???.ZIP for my .CPI file decompiler.",CR,LF
        db      "------------------------------------------------------------------------------",CR,LF
        db      CTLZ

; #############################################################################

Code Ends
END NECPINW_CPI

; End of file                           ; P
