
;--- these files contains things for 32-bit ONLY

?RING0EXC		EQU 1		; 1=display more infos on exc in ring 0
?ROMRO			EQU 1		; 1=make ROM page FF000 r/o
?ALTBOOT		EQU 1		; 1=support ALTBOOT option
?MMASK			EQU 1		; 1=trap DMA master mask port (0F, DE)
?INVLPG			EQU 1		; 1=use INVLPG opcode on 80486+
?EMM4F			EQU 1		; 1=implement int 67h, ah=4Fh
?EMM5556		EQU 1		; 1=implement int 67h, ah=55h/56h
?CLEARHIGHESP	EQU 1		; 1=clear hiword(esp) for buggy VCPI clients
?USEINT10		EQU 1		; 1=use int 10h for output, 0=use int 29h
if ?INTEGRATED
?IRQWINDOW		EQU 1		; 1=implement interrupt window
else
?IRQWINDOW		EQU 1
endif
?INT20API		equ 1		; 1=implement int 20h dynamic linking API

?SAFEMODE		EQU 0		; 1=additional security
?CODEIN2PAGE	EQU 0		; 1=move code away from first page
?UNIMPL_EMS_DBG	EQU	0		; 1=display a msg if an unimpl EMS func is called
?USETRIPLEFAULT	EQU 0		; 1=use triple fault to reboot

;--- the following equates define Jemm's memory layout:
;--- system space is E0000000h-E03FFFFFh
;--- page dir is at offset +1000h, page table 0+1 at +2000h and +3000h
;--- scratch region starts at +1F8000h (size 2 MB + 32 kB)
;--- DMA buffer at +1B8000h-1D7FFFh
;--- if XMS handle array is in HMA, a HMA copy starts at +1E8000h 

?SYSLINEAR		EQU 0F8001000h						; system space
?SYSPDE 		EQU (?SYSLINEAR shr 20) and 0FFFh	; offset in pagedir
?SYSPTE 		EQU (?SYSLINEAR shr 10) and 0FFFh	; offset in page table

?SCRATCHPTE 	EQU 800h-8*4		; offset in sys page table scratch PTEs
?SCRATCHLINEAR	EQU ?SYSPDE shl 20 + ?SCRATCHPTE shl 10
?DMAPTE 		EQU ?SCRATCHPTE - 40h*4; start PTEs for DMA buffer
?DMALINEAR		EQU ?SYSPDE shl 20 + ?DMAPTE shl 10 ; linear address DMA buffer
?HMAPTE 		EQU ?SCRATCHPTE - 10h*4; start PTEs for HMA copy
?HMALINEAR		EQU ?SYSPDE shl 20 + ?HMAPTE shl 10 ; linear address HMA copy

?BASE			EQU 110000h			; base of Jemm 32bit code
?PAGEDIR		equ ?SYSLINEAR		; page dir is mapped at a fix linear address
?TOS			EQU ?SYSLINEAR + 3000h + 1000h	;top of ring 0 stack
?TSSBASE		EQU ?TOS

@KB_FLAG		EQU 417H			; Status SHIFT/CTRL/ALT etcetera.
@RESET_FLAG 	EQU 472H			; Flag for Warmboot (=1234h)

if ?DMA or ?VDS
?DMABUFFMAX		EQU 128				; max DMA-Buffer size in kB
endif

if ?DMA

;--- bits in GblFlags

HiLoFlag1		EQU 	0	  ; adressing the Hi-Byte , DMA #1
HiLoFlag2		EQU 	1	  ; Same for DMA controller #2
NeedBuffer		EQU 	2	  ; if DMA buffer is required

endif

if ?VCPI

; VCPI switch from V86 to protected mode data structure

V862PM	STRUC
swCR3		DD	?	; client's CR3 value
swGDTOFFS	DD	?	; offset of client's GDTR value
swIDTOFFS	DD	?	; offset of client's IDTR value
swLDTR		DW	?	; client's LDTR value
swTR		DW	?	; client's TR value
swCSEIP 	DF	?	; entry point in client
V862PM	ENDS

endif

@assumem macro reg_, pstruct_
if ?MASM
	assume reg_: pstruct_
endif
	endm

;--- EMS constants

;-- 32M max EMS memory (in 16K EMS page units), always even
;-- this constant is also defined in Jemm386c.c

MAX_EMS_PAGES_ALLOWED	EQU	800h

;-- 120 MB max VCPI memory (in 16 kB units)
;-- keep this value low for buggy VCPI clients
;-- that fail with large free amounts
;-- this constant is also defined in Jemm386c.c

MAXMEM16K_DEFAULT	EQU	1E00h	; 120M in 16K blocks

MAX_HANDLES 	EQU 	255   ; There are only 255 handles to give away (lt.
							  ; Documentation  LIM EMS 4.0)
FREEPAGE_ID 	EQU 	255   ; Owner Handle of a free page

;--- EMS handle status

EMSH_SYSTEM	equ -1
EMSH_FREE	equ -2
EMSH_USED	equ -3

;--- EMS status codes

EMSS_OK					equ 00h
EMSS_SOFTWARE_ERR 		equ 80h	;unexpected error
EMSS_HARDWARE_ERR 		equ 81h	;should never occur with EMM emulators
EMSS_EMM_BUSY			equ 82h	;should never occur with EMS 3.2+	
EMSS_INVALID_HANDLE		equ 83h
EMSS_INVALID_FUNCTION	equ 84h	;function code in AH not defined
EMSS_NO_MORE_HANDLES	equ 85h	;all handles in use
EMSS_CONTEXT_EXISTS		equ 86h	;45h: try to free a handle with saved context
EMSS_OUT_OF_PAGES		equ 87h	;43h, 51h, 5A00h, 5A01h
EMSS_OUT_OF_FREE_PAGES	equ 88h	;43h, 51h, 5A00h, 5A01h
EMSS_ZERO_PAGES			equ 89h	;43h
EMSS_LOG_PAGE_INVALID	equ 8Ah	;44h, 50h, 55h, 56h, 57h
EMSS_PHYS_PAGE_INVALID	equ 8Bh	;44h, 4Fh, 50h, 55h, 56h
EMSS_CONTEXT_STACK_FULL equ 8Ch	;cannot happen with Jemm
EMSS_STATE_ALREADY_SAVED equ 8Dh;47h
EMSS_NO_STATE_IS_SAVED	equ 8Eh	;48h
EMSS_INVALID_SUBFUNC	equ 8Fh


;--- EMS pool descriptor
;--- for 4 GB, there are 4096/1.5 = 2731 possible descriptor IDs

EMSPD struc
wNibOfs dw ?		;nibble offset in pool descriptor for a 16k EMS page
wPD		dw ?		;pool descriptor ID (offset/64 into PoolAlloc array)
EMSPD ends

;--- Memory pool descriptor item
;--- this table can grow up to 174784 bytes (64*2731) for 4 GB
;--- standard is 80*64 = 5120 bytes for 120 MB

POOL_SYSTEM_INFO	struc
psi_addressK	DD ? ; base address in K (may not be XMS handle base if handle size changed later)
psi_descptr		DD ? ; pointer to XMS handle descriptor array entry/pseudo-handle value
psi_startadj	DB ? ; unused K from XMS handle base for 4K alignment (0-3)
psi_endadj		DB ? ; unused K at XMS handle end as 32K chunks (0-31)
psi_16kmax		DB ? ; maximum number of 16K allocations (used allocation bytes*2), always even
psi_16kfree		DB ? ; free number of 16K slots
psi_4kfree		DW ? ; free number of 4K slots (>psi_16kfree*4 if any partials)
psi_flags		DB ? ; various flag values
				DB ? ; alignment
POOL_SYSTEM_INFO	ends

; number of bytes for system info in EMS/VCPI pool allocation block,
;  must be >= sizeof POOL_SYSTEM_INFO or bad things will happen quickly

POOLBLOCK_SYSTEM_SPACE	EQU	16

; number of bytes for allocation in a pool allocation block
; that are 48*8=384 bits, -> 384 * 4 kB -> 1536 kB

POOLBLOCK_ALLOCATION_SPACE	EQU	48

POOLBLOCK_TOTAL_SPACE	EQU	POOLBLOCK_SYSTEM_SPACE+POOLBLOCK_ALLOCATION_SPACE

if ?MASM
LPPOOL_SYSTEM_INFO typedef ptr POOL_SYSTEM_INFO
endif

POOLBLOCK_FLAG_DONTEXPAND	EQU	1	; don't try to expand or release this pool allocation block

;--- VDS

;--- flags in DX used by various VDS functions

VDSF_COPY		equ 02h
VDSF_NOBUFFER	equ 04h
VDSF_64KALIGN	equ 10h
VDSF_128KALIGN	equ 20h
VDSF_PTE		equ 40h	;1=scatter_lock returns PTEs 

;--- DDS, used by 03-04, 07-08, 09-0A

DDS struc
dwSize	dd ?	;+0  size of region
dwOfs	dd ?	;+4  offset virtual start address
wSeg	dw ?	;+8  segment/selector virtual start address (or 0000)
wID		dw ?	;+10 buffer ID
dwPhys	dd ?	;+12 physical address
DDS ends

;--- EDDS, used by 05-06

EDDS struc
dwSize	dd ?	;+0
dwOfs	dd ?	;+4
wSeg	dw ?	;+8
wRes	dw ?	;+10
wNumAvail	dw ?	;+12
wNumUsed	dw ?	;+14
EDDS ends

;--- EDDS suffix for regions

EDDSRG struc
dwPhysAddr	dd ?	;+16
dwSizeRg	dd ?	;+20
EDDSRG ends

;--- EDDS suffix for PTEs

EDDSPT struc
dwPTE		dd ?	;+16
EDDSPT ends

;--- end VDS

;--- TSS structure
;--- the only fields in the TSS which are needed are tsEsp0, tsSS0
;--- and tsOfs. Jemm386 will never switch tasks.

TSSSEG	struc
		dd ?	;+00 selector
tsEsp0	dd ?	;+04
tsSS0	dd ?	;+08
		dq ?	;+0C
		dq ?	;+14
tsCR3	dd ?	;+1C
tsEip	dd ?	;+20
tsEfl	dd ?	;+24
tsEax	dd ?	;+28
tsEcx	dd ?	;+2C
tsEdx	dd ?	;+30
tsEbx	dd ?	;+34
tsEsp	dd ?	;+38
tsEbp	dd ?	;+3C
tsEsi	dd ?	;+40
tsEdi	dd ?	;+44
tsES	dd ?	;+48
tsCS	dd ?	;+4C
tsSS	dd ?	;+50
tsDS	dd ?	;+54
tsFS	dd ?	;+58
tsGS	dd ?	;+5C
tsLDTR	dd ?	;+60
tsFlags	dw ?	;+64
tsOfs	dw ?	;+66
TSSSEG	ends

;--- stack frame for PUSHAD

PUSHADS struc
rEDI	dd ?
rESI	dd ?
rEBP	dd ?
        dd ?	;reserved
rEBX	dd ?
rEDX	dd ?
rECX	dd ?
rEAX	dd ?
PUSHADS ends

;--- IRET stack frame for 32bit protected-mode

IRETD32	struc
pEIP	dd ?	;+0
pCS		dd ?	;+4	
pEFL 	dd ?	;+8
IRETD32	ends

;--- stack frame for normal INTs in v86 mode

IRETDV86 struc
vEIP	dd ?	;+0
vCS		dd ?	;+4	
vEFL 	dd ?	;+8
vESP	dd ?	;+12
vSS		dd ?	;+16
vES		dd ?	;+20
vDS		dd ?	;+24
vFS		dd ?	;+28
vGS		dd ?	;+32
IRETDV86 ends

;--- client register structure in V86 monitor.
;--- consists of:
;--- 1. PUSHAD
;--- 2. Int#
;--- 3. v86-exception frame with error code

Client_Reg_Struc  struc
Client_EDI	dd ?    ;+0
Client_ESI  dd ?    ;+4
Client_EBP	dd ?    ;+8
Client_res0 dd ?    ;+12
Client_EBX	dd ?	;+16
Client_EDX	dd ?	;+20
Client_ECX	dd ?	;+24
Client_EAX	dd ?	;+28
Client_Int	dd ?	;+32
Client_Error dd ?	;+36
Client_EIP	dd ?	;+40
Client_CS	dd ?	;+44	
Client_EFlags dd ?	;+48
Client_ESP	dd ?	;+52
Client_SS	dd ?	;+56
Client_ES	dd ?	;+60
Client_DS	dd ?	;+64
Client_FS	dd ?	;+68
Client_GS	dd ?	;+72
Client_Reg_Struc ends		

;--- stack frame in V86 monitor for IRQs and software INTs
;--- consists of PUSHAD, Int# + v86-IRETD frame

V86FRAME struc
fEDI	dd ?
fESI	dd ?
fEBP	dd ?
		dd ?
fEBX	dd ?	;+4
fEDX	dd ?	;+0
fECX	dd ?	;+0
fEAX	dd ?	;+8
fIntNo  dd ?	;+12
fEIP	dd ?	;+16
fCS		dd ?	;+20
fEFL	dd ?	;+24
fESP	dd ?	;+28
fSS		dd ?	;+32
fES		dd ?	;+36
fDS		dd ?	;+40
fFS		dd ?	;+44
fGS		dd ?	;+48
V86FRAME ends		 

;--- entry in IO trap table

IOTRAPENTRY struc
bStart	db ?
bEnd	db ?
dwProc	dd ?
IOTRAPENTRY ends

;--- structure for calling a v86 far proc with IRET/RETF frame

if ?INT20API
VMM_SERV_TABLE struc
pSimulate_Int 			dd ?
pSimulate_Iret 			dd ?
pSimulate_Far_Call 		dd ?
pSimulate_Far_Ret  		dd ?
pBegin_Nest_Exec		dd ?
pExec_Int				dd ?
pResume_Exec 			dd ?
pEnd_Nest_Exec			dd ?
pSimulate_IO			dd ?
pYield					dd ?
pVDS_Call_Table 		dd ?
pVCPI_Call_Table 		dd ?
pIO_Trap_Table			dd ?
pV86_Monitor			dd ?
pStackCurr  			dd ?
VMM_SERV_TABLE ends
endif

;--- macros

; Macro for bypassing the 386-Bug with 32-Bit-Stringoperations
; only needed for Mask-version B3
; AddressSize - Prefix + NOP attached
; obsolete, since Jemm386 now runs in a 32bit code segment

@BIG_NOP MACRO
;;		DB 67h	  ;  32-Bit-Prefix
;;		NOP
		ENDM

@mov_eax_cr4 macro
	db 0fh, 20h, 0E0h
	endm
@mov_ecx_cr4 macro
	db 0fh, 20h, 0E1h
	endm

@mov_cr4_eax macro
	db 0fh, 22h, 0E0h
	endm
@mov_cr4_ecx macro
	db 0fh, 22h, 0E1h
	endm
@mov_cr4_edx macro
	db 0fh, 22h, 0E2h
	endm

@cpuid	macro
;	cpuid
	db 0Fh,0A2h
	endm

@wrmsr	macro
	db 0Fh,030h
	endm
	
@rdtsc	macro
	db 0Fh,031h
	endm

@rdmsr	macro
	db 0Fh,032h
	endm
 
;--- macro to get a pointer to PTEs
;--- reg: register to set
;--- ofs: offset in page dir/page table
;--- bIsConst: if blank, then ofs is/contains a register
 
@GETPTEPTR macro reg, ofs, bIsConst
if 0
	mov reg,[PAGEDIR]
  ifnb <ofs>  
	lea reg, [reg+ofs]
  endif  
else
  ifnb <ofs>
	ifnb <bIsConst>
	  mov reg,?PAGEDIR+ofs
	else
	  lea reg,[?PAGEDIR+ofs]
	endif
  else
	mov reg, ?PAGEDIR
  endif
endif
	endm

@GETPTE macro reg, ofs, bIsConst
if 0
	mov reg,[PAGEDIR]
	mov reg,[reg+ofs]
else
	ifnb <bIsConst>
	  mov reg,ds:[?PAGEDIR+ofs]
	else
	  mov reg,[?PAGEDIR+ofs]
	endif
endif
	endm

